﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasLoginCache.h>
#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/baas/account_BaasUserInfoHolder.h>
#include <nn/account/detail/account_Execution.h>
#include <nn/account/ndas/account_NdasOperator.h>
#include <nn/account/account_NintendoAccountTypes.h>

#include <curl/curl.h>

namespace nn { namespace account { namespace baas {

class BaasUserDriver
{
    NN_DISALLOW_COPY(BaasUserDriver);

public:
    static const size_t RequiredBufferSize;

private:
    const UserAccessTokenCache& m_UserAccessTokenCache;
    const detail::AbstractLocalStorage& m_Storage;

public:
    BaasUserDriver(
        const UserAccessTokenCache& userAccessTokenCache,
        const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    Result UploadImage(
        char* url, size_t urlSize,
        const NetworkServiceAccountId& id, const detail::Uuid& cacheId,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        void* largeRawBuffer, size_t largeRawBufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result DownloadImage(
        size_t* pOutActualSize, void* buffer, size_t bufferSize,
        const char* url, size_t urlSize,
        CURL* curlHandle,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result UploadProfile(
        const NetworkServiceAccountId& id, const UserProfile& profile,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result DownloadProfile(
        UserProfile* pProfile,
        const NetworkServiceAccountId& id,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    /* --------------------------------------------------------
        Link
    */
    Result LinkWithNintendoAccount(
        const NetworkServiceAccountId& id, const NintendoAccountId& naId, const detail::Uuid& idTokenCacheId,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result UnlinkFromNintendoAccount(
        const NetworkServiceAccountId& id,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::baas

