﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief アカウント選択 UI の実装に使用する型を宣言します。 (非公開)
 */

#include <nn/nn_ApplicationId.h>
#include <nn/nn_StaticAssert.h>
#include <nn/account/account_SelectorForSystemServices.h>
#include <nn/account/account_TypesForSystemServices.h>
#include <nn/err/err_Types.h>

namespace nn { namespace account {

/**
* @brief アプレット起動モードを示す列挙子です。
*/
enum UiMode
{
    UiMode_SelectUser = 0,                  //!< ユーザー選択
    UiMode_CreateUser = 1,                  //!< ユーザー新規作成
    UiMode_EnsureNsaAvailable = 2,          //!< ネットワークサービスアカウントの可用性の確保
    UiMode_EditUserIcon = 3,                //!< ユーザーアイコン編集
    UiMode_EditUserNickname = 4,            //!< ユーザーニックネーム編集
    UiMode_CreateUserForStarter = 5,        //!< 初回起動用ユーザー新規作成
    UiMode_ApplicationAuthorization = 6,    //!< アプリケーション向け認可取得
    UiMode_IntroduceExternalNsa = 7,        //!< 外部ネットワークサービスアカウントのログイン
    UiMode_IntroduceExternalNsaForRegistration = 8, //!< 外部ネットワークサービスアカウントのログイン (本体への登録用)
    UiMode_LinkNnidWithNa = 9,              //!< ニンテンドーアカウントとNNIDの連携
    UiMode_RequireLicense = 10,             //!< 資格の要求
};

enum LicenseType
{
    LicenseType_Op2Common = 0,
};

/**
*   @brief アプレットへの引数
*/
struct UiSettings
{
    uint32_t mode;
    uint32_t _padding0;

    union
    {
        // モード別に union で定義

        struct {
            nn::account::Uid  invalidUidList[nn::account::UserCountMax];
            nn::ApplicationId applicationId;
            bool  isNetworkServiceAccountRequired;
            bool  isSkipEnabled;
            bool  forSystem;
            bool  isUserRegistrationPermitted;
            bool  showSkipButton;
            bool  additionalSelect;
            bool  showAddButton;
            bool  invalidateUnqualified; //!< UserSelectionSettings のフラグと反転していることに注意
            uint32_t purpose;
            uint32_t _padding2;
        } select;

        struct {
            uint32_t _padding1[38];
        } create;

        struct {
            nn::account::Uid uid;
            uint32_t startupDialogType;
            uint32_t _padding1[33];
        } ensureNsaAvailable;

        struct {
            nn::account::Uid uid;
            uint32_t _padding1[34];
        } editUserIcon;

        struct {
            nn::account::Uid uid;
            uint32_t _padding1[34];
        } editUserNickname;

        struct {
            nn::account::Uid uid;
            nn::account::SessionId sessionId;
            uint32_t _padding1[30];
        } applicationAuthorization;

        struct {
            nn::account::SessionId sessionId;
            uint32_t _padding1[34];
        } introduceExternalNsa;

        struct {
            nn::account::SessionId sessionId;
            uint32_t _padding1[34];
        } introduceExternalNsaForRegistration;

        struct {
            nn::account::Uid uid;
            uint32_t _padding1[34];
        } linkNnidWithNa;

        struct {
            nn::account::Uid uid;
            uint32_t licenseType;
            err::ErrorCode errorCode;
            uint32_t _padding1[31];
        } requireLicense;
    };

    UiMode GetUiMode() const NN_NOEXCEPT;
    NintendoAccountStartupDialogType GetNintendoAccountStartupDialogType() const NN_NOEXCEPT;
    LicenseType GetLicenseType() const NN_NOEXCEPT;
};
NN_STATIC_ASSERT(sizeof(UiSettings) == 160);
NN_STATIC_ASSERT(std::is_pod<UiSettings>::value);

}} // ~namespace nn::account
