﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief ユーザーアカウントを特定しないネットワークサービス向けの機能を宣言します。
 */
#include <nn/nn_Result.h>
#include <nn/account/account_AsyncContext.h>

namespace nn { namespace account {

/**
    @brief ユーザーアカウントを特定しないネットワークサービスの利用に必要な認証処理を行います。

    @param[out] pOut 非同期処理の完了と結果の通知を受けるための nn::account::AsyncContext オブジェクト

    @retresult
        @handleresult{
            nn::ResultSuccess,
            処理に成功しました。
            ネットワークサービスを利用可能かの認証結果は、本関数に指定する nn::account::AsyncContext オブジェクトが返却します。
        }
    @endretresult

    @pre
        - ライブラリが初期化済み
        - pOut != nullptr
    @post
        - *pOut は有効

    @details
        ユーザーアカウントを特定しないネットワークサービスの利用に必要な認証処理を行います。
        この認証処理は、本体システムに登録されたいずれかのネットワークサービスアカウントへのログイン処理を含みます。
        ただし認証に使用されたユーザーアカウントやネットワークサービスアカウントの情報を取得することはできません。

        ネットワークサービスを利用可能かの認証結果は、本関数に指定する nn::account::AsyncContext オブジェクトが返却します。

        この関数は、ユーザーアカウントを特定しないネットワークサービスを提供するプログラムから呼ばれることを想定しています。
        ユーザーアカウントを特定してネットワークサービスを提供する場合の認証には nn::account::EnsureNetworkServiceAccountIdTokenCacheAsync() を使用してください。
*/
Result CheckNetworkServiceAvailabilityAsync(AsyncContext* pOut) NN_NOEXCEPT;

}}  // ~namespace nn::account
