﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/account/account_TypesForSystemServices.h>
#include <nn/account/baas/account_Interface.sfdl.h>
#include <nn/account/detail/account_IAsyncContext.sfdl.h>
#include <nn/account/detail/account_INotifier.sfdl.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_ISessionObject.sfdl.h>
#include <nn/account/nas/account_Interface.sfdl.h>
#include <nn/account/profile/account_Interface.sfdl.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/npns/npns_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace account { // NOLINT(whitespace/braces)

class IAccountServiceBase;

class IAccountServiceForAdministrator;

class IAccountServiceForApplication;

class IAccountServiceForSystemService;

class IBaasAccessTokenAccessor;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAccountServiceBase, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAccountServiceBase)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserCount, (::nn::sf::Out<::std::int32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserExistence, (::nn::sf::Out<bool> pOutExistence, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAllUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOpenedUser, (::nn::sf::Out<::nn::account::Uid> pOutUid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfile>> pOutProfile, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileDigest, (::nn::sf::Out<::nn::account::ProfileDigest> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsUserRegistrationRequestPermitted, (::nn::sf::Out<bool> pOut, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TrySelectUserWithoutInteraction, (::nn::sf::Out<::nn::account::Uid> pOut, bool isNetworkServiceAccountRequired))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAccountServiceBase)

        ::nn::Result GetUserCount(::nn::sf::Out<::std::int32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserCount, (pOutCount));
        }

        ::nn::Result GetUserExistence(::nn::sf::Out<bool> pOutExistence, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserExistence, (pOutExistence, uid));
        }

        ::nn::Result ListAllUsers(const ::nn::sf::OutArray<::nn::account::Uid>& outUsers) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), outUsers)), "_.GetLength() == ::nn::account::UserCountMax (where _ = outUsers)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAllUsers, (outUsers));
        }

        ::nn::Result ListOpenUsers(const ::nn::sf::OutArray<::nn::account::Uid>& outUsers) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), outUsers)), "_.GetLength() == ::nn::account::UserCountMax (where _ = outUsers)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListOpenUsers, (outUsers));
        }

        ::nn::Result GetLastOpenedUser(::nn::sf::Out<::nn::account::Uid> pOutUid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastOpenedUser, (pOutUid));
        }

        ::nn::Result GetProfile(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfile>> pOutProfile, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfile, (pOutProfile, uid));
        }

        ::nn::Result GetProfileDigest(::nn::sf::Out<::nn::account::ProfileDigest> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileDigest, (pOut, uid));
        }

        ::nn::Result IsUserRegistrationRequestPermitted(::nn::sf::Out<bool> pOut, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsUserRegistrationRequestPermitted, (pOut, pid));
        }

        ::nn::Result TrySelectUserWithoutInteraction(::nn::sf::Out<::nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TrySelectUserWithoutInteraction, (pOut, isNetworkServiceAccountRequired));
        }

        ::nn::Result DebugActivateOpenContextRetention(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugActivateOpenContextRetention, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAccountServiceBase
    {
    public:
        nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
        nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
        nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
        nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
        nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;
        nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
    nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;
    nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::IAccountServiceBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserCount, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserCount, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserExistence, (::nn::sf::Out<bool> pOutExistence, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserExistence, (pOutExistence, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAllUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAllUsers, (outUsers));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListOpenUsers, (outUsers));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOpenedUser, (::nn::sf::Out<::nn::account::Uid> pOutUid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastOpenedUser, (pOutUid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfile>> pOutProfile, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfile, (pOutProfile, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileDigest, (::nn::sf::Out<::nn::account::ProfileDigest> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileDigest, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUserRegistrationRequestPermitted, (::nn::sf::Out<bool> pOut, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsUserRegistrationRequestPermitted, (pOut, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TrySelectUserWithoutInteraction, (::nn::sf::Out<::nn::account::Uid> pOut, bool isNetworkServiceAccountRequired))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TrySelectUserWithoutInteraction, (pOut, isNetworkServiceAccountRequired));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugActivateOpenContextRetention, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::IAccountServiceBase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::IAccountServiceBase))

    // nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserCount)

    // nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserExistence)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutExistence, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutExistence))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutExistence), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserExistence)

    // nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAllUsers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAllUsers)

    // nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListOpenUsers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListOpenUsers)

    // nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastOpenedUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutUid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutUid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutUid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastOpenedUser)

    // nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutProfile, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfile)

    // nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileDigest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::ProfileDigest), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileDigest)

    // nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsUserRegistrationRequestPermitted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsUserRegistrationRequestPermitted)

    // nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TrySelectUserWithoutInteraction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isNetworkServiceAccountRequired, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isNetworkServiceAccountRequired))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isNetworkServiceAccountRequired)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TrySelectUserWithoutInteraction)

    // nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugActivateOpenContextRetention)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(99)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugActivateOpenContextRetention)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::ProfileDigest), 16, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::IAccountServiceBase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::IAccountServiceBase))

    // nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserCount, (::nn::sf::Out<::std::int32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserCount)
    }

    // nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserExistence, (::nn::sf::Out<bool> pOutExistence, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserExistence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutExistence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserExistence)
    }

    // nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAllUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAllUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAllUsers)
    }

    // nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListOpenUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListOpenUsers)
    }

    // nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOpenedUser, (::nn::sf::Out<::nn::account::Uid> pOutUid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastOpenedUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutUid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastOpenedUser)
    }

    // nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfile>> pOutProfile, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfile)
    }

    // nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileDigest, (::nn::sf::Out<::nn::account::ProfileDigest> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileDigest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileDigest)
    }

    // nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUserRegistrationRequestPermitted, (::nn::sf::Out<bool> pOut, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsUserRegistrationRequestPermitted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsUserRegistrationRequestPermitted)
    }

    // nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TrySelectUserWithoutInteraction, (::nn::sf::Out<::nn::account::Uid> pOut, bool isNetworkServiceAccountRequired))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TrySelectUserWithoutInteraction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isNetworkServiceAccountRequired)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TrySelectUserWithoutInteraction)
    }

    // nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugActivateOpenContextRetention)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugActivateOpenContextRetention)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::IAccountServiceBase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::IAccountServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserExistence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserExistence)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutExistence),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAllUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAllUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListOpenUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListOpenUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastOpenedUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastOpenedUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutUid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::profile::IProfile>), pOutProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutProfile, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileDigest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileDigest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsUserRegistrationRequestPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsUserRegistrationRequestPermitted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TrySelectUserWithoutInteraction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TrySelectUserWithoutInteraction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isNetworkServiceAccountRequired)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugActivateOpenContextRetention)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugActivateOpenContextRetention)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserExistence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAllUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListOpenUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastOpenedUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileDigest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsUserRegistrationRequestPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TrySelectUserWithoutInteraction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugActivateOpenContextRetention)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::IAccountServiceBase))

namespace nn { namespace account { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAccountServiceForSystemService, (::nn::account::IAccountServiceBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAccountServiceForSystemService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserRegistrationNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserStateChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForSystemService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForSystemService>> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasUserAvailabilityChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileUpdateNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId, const ::nn::sf::InBuffer& imageBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadSaveDataThumbnail, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataThumbnailExistence, (::nn::sf::Out<bool> pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserLastOpenedApplication, (::nn::sf::Out<::nn::ApplicationId> pOutApplicationId, ::nn::sf::Out<::std::uint32_t> pOutApplicationVersion, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugInvalidateUserResourceCache, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateClose, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateOpen, (const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAccountServiceForSystemService)

        ::nn::Result GetUserRegistrationNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserRegistrationNotifier, (pOutNotifier));
        }

        ::nn::Result GetUserStateChangeNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserStateChangeNotifier, (pOutNotifier));
        }

        ::nn::Result GetBaasAccountManagerForSystemService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForSystemService>> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForSystemService, (pOut, uid));
        }

        ::nn::Result GetBaasUserAvailabilityChangeNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBaasUserAvailabilityChangeNotifier, (pOutNotifier));
        }

        ::nn::Result GetProfileUpdateNotifier(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileUpdateNotifier, (pOutNotifier));
        }

        ::nn::Result CheckNetworkServiceAvailabilityAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), identification)), "_.id != ::nn::ApplicationId::GetInvalidId() (where _ = identification)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (pOutContext, identification, pid));
        }

        ::nn::Result StoreSaveDataThumbnail(const ::nn::account::Uid& uid, ::nn::ApplicationId appId, const ::nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), imageBuffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = imageBuffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (uid, appId, imageBuffer));
        }

        ::nn::Result ClearSaveDataThumbnail(const ::nn::account::Uid& uid, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (uid, appId));
        }

        ::nn::Result LoadSaveDataThumbnail(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadSaveDataThumbnail, (pOutActualSize, pOut, uid, appId));
        }

        ::nn::Result GetSaveDataThumbnailExistence(::nn::sf::Out<bool> pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSaveDataThumbnailExistence, (pOut, uid, appId));
        }

        ::nn::Result ActivateOpenContextRetention(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateOpenContextRetention, (pOut, appId));
        }

        ::nn::Result ListQualifiedUsers(const ::nn::sf::OutArray<::nn::account::Uid>& outUsers, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), outUsers)), "_.GetLength() == ::nn::account::UserCountMax (where _ = outUsers)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (outUsers, appId));
        }

        ::nn::Result GetUserLastOpenedApplication(::nn::sf::Out<::nn::ApplicationId> pOutApplicationId, ::nn::sf::Out<::std::uint32_t> pOutApplicationVersion, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserLastOpenedApplication, (pOutApplicationId, pOutApplicationVersion, uid));
        }

        ::nn::Result DebugInvalidateUserResourceCache(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugInvalidateUserResourceCache, (uid));
        }

        ::nn::Result DebugSetUserStateClose(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugSetUserStateClose, (uid));
        }

        ::nn::Result DebugSetUserStateOpen(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugSetUserStateOpen, (uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAccountServiceForSystemService : public ::nn::account::IAccountServiceBase
    {
    public:
        nn::Result GetUserRegistrationNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
        nn::Result GetUserStateChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
        nn::Result GetBaasAccountManagerForSystemService(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForSystemService>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetBaasUserAvailabilityChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
        nn::Result GetProfileUpdateNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
        nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT;
        nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result LoadSaveDataThumbnail(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result GetSaveDataThumbnailExistence(nn::sf::Out<bool> pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result GetUserLastOpenedApplication(nn::sf::Out<nn::ApplicationId> pOutApplicationId, nn::sf::Out<std::uint32_t> pOutApplicationVersion, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DebugInvalidateUserResourceCache(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DebugSetUserStateClose(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DebugSetUserStateOpen(const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
    nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;
    nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    nn::Result GetUserRegistrationNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetUserStateChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetBaasAccountManagerForSystemService(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForSystemService>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetBaasUserAvailabilityChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetProfileUpdateNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT;
    nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result LoadSaveDataThumbnail(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetSaveDataThumbnailExistence(nn::sf::Out<bool> pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetUserLastOpenedApplication(nn::sf::Out<nn::ApplicationId> pOutApplicationId, nn::sf::Out<std::uint32_t> pOutApplicationVersion, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DebugInvalidateUserResourceCache(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DebugSetUserStateClose(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DebugSetUserStateOpen(const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::IAccountServiceForSystemService), (::nn::account::IAccountServiceBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserRegistrationNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserRegistrationNotifier, (pOutNotifier));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserStateChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserStateChangeNotifier, (pOutNotifier));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForSystemService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForSystemService>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBaasAccountManagerForSystemService, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasUserAvailabilityChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBaasUserAvailabilityChangeNotifier, (pOutNotifier));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileUpdateNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileUpdateNotifier, (pOutNotifier));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (pOutContext, identification, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId, const ::nn::sf::InBuffer& imageBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StoreSaveDataThumbnail, (uid, appId, imageBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearSaveDataThumbnail, (uid, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadSaveDataThumbnail, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadSaveDataThumbnail, (pOutActualSize, pOut, uid, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataThumbnailExistence, (::nn::sf::Out<bool> pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSaveDataThumbnailExistence, (pOut, uid, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateOpenContextRetention, (pOut, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListQualifiedUsers, (outUsers, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserLastOpenedApplication, (::nn::sf::Out<::nn::ApplicationId> pOutApplicationId, ::nn::sf::Out<::std::uint32_t> pOutApplicationVersion, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserLastOpenedApplication, (pOutApplicationId, pOutApplicationVersion, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugInvalidateUserResourceCache, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugInvalidateUserResourceCache, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateClose, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugSetUserStateClose, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateOpen, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugSetUserStateOpen, (uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::IAccountServiceForSystemService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::IAccountServiceForSystemService), (::nn::account::IAccountServiceBase))

    // nn::Result GetUserRegistrationNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserRegistrationNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutNotifier, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutNotifier))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNotifier)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserRegistrationNotifier)

    // nn::Result GetUserStateChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserStateChangeNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutNotifier, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutNotifier))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNotifier)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserStateChangeNotifier)

    // nn::Result GetBaasAccountManagerForSystemService(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForSystemService>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBaasAccountManagerForSystemService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBaasAccountManagerForSystemService)

    // nn::Result GetBaasUserAvailabilityChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBaasUserAvailabilityChangeNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutNotifier, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutNotifier))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNotifier)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBaasUserAvailabilityChangeNotifier)

    // nn::Result GetProfileUpdateNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileUpdateNotifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutNotifier, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutNotifier))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNotifier)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileUpdateNotifier)

    // nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckNetworkServiceAvailabilityAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(105)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(identification, 0, (const ::nn::account::SystemProgramIdentification&), 16, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (identification))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(identification), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckNetworkServiceAvailabilityAsync)

    // nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreSaveDataThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreSaveDataThumbnail)

    // nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearSaveDataThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearSaveDataThumbnail)

    // nn::Result LoadSaveDataThumbnail(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadSaveDataThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(112)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadSaveDataThumbnail)

    // nn::Result GetSaveDataThumbnailExistence(nn::sf::Out<bool> pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSaveDataThumbnailExistence)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(113)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSaveDataThumbnailExistence)

    // nn::Result ActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateOpenContextRetention)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateOpenContextRetention)

    // nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListQualifiedUsers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(140)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListQualifiedUsers)

    // nn::Result GetUserLastOpenedApplication(nn::sf::Out<nn::ApplicationId> pOutApplicationId, nn::sf::Out<std::uint32_t> pOutApplicationVersion, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserLastOpenedApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(190)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutApplicationVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutApplicationId, (::nn::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutApplicationVersion, pOutApplicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutApplicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutApplicationVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserLastOpenedApplication)

    // nn::Result DebugInvalidateUserResourceCache(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugInvalidateUserResourceCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(997)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugInvalidateUserResourceCache)

    // nn::Result DebugSetUserStateClose(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugSetUserStateClose)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(998)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugSetUserStateClose)

    // nn::Result DebugSetUserStateOpen(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugSetUserStateOpen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(999)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugSetUserStateOpen)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::ProfileDigest), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::SystemProgramIdentification), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::IAccountServiceForSystemService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::IAccountServiceForSystemService), (::nn::account::IAccountServiceBase))

    // nn::Result GetUserRegistrationNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserRegistrationNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserRegistrationNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNotifier)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserRegistrationNotifier)
    }

    // nn::Result GetUserStateChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserStateChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserStateChangeNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNotifier)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserStateChangeNotifier)
    }

    // nn::Result GetBaasAccountManagerForSystemService(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForSystemService>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForSystemService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForSystemService>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBaasAccountManagerForSystemService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBaasAccountManagerForSystemService)
    }

    // nn::Result GetBaasUserAvailabilityChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasUserAvailabilityChangeNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBaasUserAvailabilityChangeNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNotifier)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBaasUserAvailabilityChangeNotifier)
    }

    // nn::Result GetProfileUpdateNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileUpdateNotifier, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::INotifier>> pOutNotifier))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileUpdateNotifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNotifier)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileUpdateNotifier)
    }

    // nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckNetworkServiceAvailabilityAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(identification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckNetworkServiceAvailabilityAsync)
    }

    // nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId, const ::nn::sf::InBuffer& imageBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreSaveDataThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreSaveDataThumbnail)
    }

    // nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearSaveDataThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearSaveDataThumbnail)
    }

    // nn::Result LoadSaveDataThumbnail(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadSaveDataThumbnail, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadSaveDataThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadSaveDataThumbnail)
    }

    // nn::Result GetSaveDataThumbnailExistence(nn::sf::Out<bool> pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSaveDataThumbnailExistence, (::nn::sf::Out<bool> pOut, const ::nn::account::Uid& uid, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSaveDataThumbnailExistence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSaveDataThumbnailExistence)
    }

    // nn::Result ActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateOpenContextRetention, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateOpenContextRetention)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateOpenContextRetention)
    }

    // nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListQualifiedUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListQualifiedUsers)
    }

    // nn::Result GetUserLastOpenedApplication(nn::sf::Out<nn::ApplicationId> pOutApplicationId, nn::sf::Out<std::uint32_t> pOutApplicationVersion, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserLastOpenedApplication, (::nn::sf::Out<::nn::ApplicationId> pOutApplicationId, ::nn::sf::Out<::std::uint32_t> pOutApplicationVersion, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserLastOpenedApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutApplicationVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserLastOpenedApplication)
    }

    // nn::Result DebugInvalidateUserResourceCache(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugInvalidateUserResourceCache, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugInvalidateUserResourceCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugInvalidateUserResourceCache)
    }

    // nn::Result DebugSetUserStateClose(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateClose, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugSetUserStateClose)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugSetUserStateClose)
    }

    // nn::Result DebugSetUserStateOpen(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetUserStateOpen, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugSetUserStateOpen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugSetUserStateOpen)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::IAccountServiceForSystemService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::IAccountServiceForSystemService), (::nn::account::IAccountServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserRegistrationNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::INotifier>), pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserRegistrationNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutNotifier, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserStateChangeNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::INotifier>), pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserStateChangeNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutNotifier, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBaasAccountManagerForSystemService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IManagerForSystemService>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBaasAccountManagerForSystemService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBaasUserAvailabilityChangeNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::INotifier>), pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBaasUserAvailabilityChangeNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutNotifier, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileUpdateNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::INotifier>), pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileUpdateNotifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutNotifier, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckNetworkServiceAvailabilityAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(identification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckNetworkServiceAvailabilityAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreSaveDataThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearSaveDataThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadSaveDataThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSaveDataThumbnailExistence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSaveDataThumbnailExistence)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateOpenContextRetention)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateOpenContextRetention)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListQualifiedUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListQualifiedUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserLastOpenedApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserLastOpenedApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutApplicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutApplicationVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugInvalidateUserResourceCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugInvalidateUserResourceCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugSetUserStateClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugSetUserStateClose)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugSetUserStateOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugSetUserStateOpen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserRegistrationNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserStateChangeNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBaasAccountManagerForSystemService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBaasUserAvailabilityChangeNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileUpdateNotifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckNetworkServiceAvailabilityAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSaveDataThumbnailExistence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateOpenContextRetention)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListQualifiedUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserLastOpenedApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugInvalidateUserResourceCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugSetUserStateClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugSetUserStateOpen)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::IAccountServiceForSystemService))

namespace nn { namespace account { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAccountServiceForAdministrator, (::nn::account::IAccountServiceForSystemService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAccountServiceForAdministrator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BeginUserRegistration, (::nn::sf::Out<::nn::account::Uid> pOutUid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistration, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelUserRegistration, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUser, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetUserPosition, (const ::nn::account::Uid& uid, ::std::int32_t position))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileEditor, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfileEditor>> pOutProfile, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistrationForcibly, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateFloatingRegistrationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateServiceAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountAdministrator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IAdministrator>> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForGuestLoginWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForFloatingRegistrationWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SuspendBackgroundDaemon, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAccountServiceForAdministrator)

        ::nn::Result BeginUserRegistration(::nn::sf::Out<::nn::account::Uid> pOutUid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BeginUserRegistration, (pOutUid));
        }

        ::nn::Result CompleteUserRegistration(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompleteUserRegistration, (uid));
        }

        ::nn::Result CancelUserRegistration(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelUserRegistration, (uid));
        }

        ::nn::Result DeleteUser(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteUser, (uid));
        }

        ::nn::Result SetUserPosition(const ::nn::account::Uid& uid, ::std::int32_t position) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetUserPosition, (uid, position));
        }

        ::nn::Result GetProfileEditor(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfileEditor>> pOutProfile, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileEditor, (pOutProfile, uid));
        }

        ::nn::Result CompleteUserRegistrationForcibly(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompleteUserRegistrationForcibly, (uid));
        }

        ::nn::Result CreateFloatingRegistrationRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateFloatingRegistrationRequest, (pOutRequest, ::std::move(workMemory), workMemorySize));
        }

        ::nn::Result AuthenticateServiceAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AuthenticateServiceAsync, (pOutContext));
        }

        ::nn::Result GetBaasAccountAdministrator(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IAdministrator>> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBaasAccountAdministrator, (pOut, uid));
        }

        ::nn::Result ProxyProcedureForGuestLoginWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ProxyProcedureForGuestLoginWithNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result ProxyProcedureForFloatingRegistrationWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ProxyProcedureForFloatingRegistrationWithNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result SuspendBackgroundDaemon(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SuspendBackgroundDaemon, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAccountServiceForAdministrator : public ::nn::account::IAccountServiceForSystemService
    {
    public:
        nn::Result BeginUserRegistration(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
        nn::Result CompleteUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result CancelUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeleteUser(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result SetUserPosition(const nn::account::Uid& uid, std::int32_t position) NN_NOEXCEPT;
        nn::Result GetProfileEditor(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfileEditor>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result CompleteUserRegistrationForcibly(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result CreateFloatingRegistrationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT;
        nn::Result AuthenticateServiceAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result GetBaasAccountAdministrator(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IAdministrator>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ProxyProcedureForGuestLoginWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result ProxyProcedureForFloatingRegistrationWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result SuspendBackgroundDaemon(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
    nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;
    nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    nn::Result GetUserRegistrationNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetUserStateChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetBaasAccountManagerForSystemService(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForSystemService>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetBaasUserAvailabilityChangeNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result GetProfileUpdateNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::INotifier>> pOutNotifier) NN_NOEXCEPT;
    nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT;
    nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result LoadSaveDataThumbnail(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetSaveDataThumbnailExistence(nn::sf::Out<bool> pOut, const nn::account::Uid& uid, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetUserLastOpenedApplication(nn::sf::Out<nn::ApplicationId> pOutApplicationId, nn::sf::Out<std::uint32_t> pOutApplicationVersion, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result BeginUserRegistration(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
    nn::Result CompleteUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CancelUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteUser(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SetUserPosition(const nn::account::Uid& uid, std::int32_t position) NN_NOEXCEPT;
    nn::Result GetProfileEditor(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfileEditor>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CompleteUserRegistrationForcibly(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CreateFloatingRegistrationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT;
    nn::Result AuthenticateServiceAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result GetBaasAccountAdministrator(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IAdministrator>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ProxyProcedureForGuestLoginWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result ProxyProcedureForFloatingRegistrationWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result SuspendBackgroundDaemon(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    nn::Result DebugInvalidateUserResourceCache(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DebugSetUserStateClose(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DebugSetUserStateOpen(const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::IAccountServiceForAdministrator), (::nn::account::IAccountServiceForSystemService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginUserRegistration, (::nn::sf::Out<::nn::account::Uid> pOutUid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BeginUserRegistration, (pOutUid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistration, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompleteUserRegistration, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelUserRegistration, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelUserRegistration, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUser, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteUser, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUserPosition, (const ::nn::account::Uid& uid, ::std::int32_t position))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetUserPosition, (uid, position));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileEditor, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfileEditor>> pOutProfile, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileEditor, (pOutProfile, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistrationForcibly, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompleteUserRegistrationForcibly, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateFloatingRegistrationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateFloatingRegistrationRequest, (pOutRequest, ::std::move(workMemory), workMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateServiceAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AuthenticateServiceAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountAdministrator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IAdministrator>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBaasAccountAdministrator, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForGuestLoginWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ProxyProcedureForGuestLoginWithNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForFloatingRegistrationWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ProxyProcedureForFloatingRegistrationWithNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendBackgroundDaemon, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SuspendBackgroundDaemon, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::IAccountServiceForAdministrator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::IAccountServiceForAdministrator), (::nn::account::IAccountServiceForSystemService))

    // nn::Result BeginUserRegistration(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginUserRegistration)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutUid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutUid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutUid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginUserRegistration)

    // nn::Result CompleteUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompleteUserRegistration)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompleteUserRegistration)

    // nn::Result CancelUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelUserRegistration)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelUserRegistration)

    // nn::Result DeleteUser(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteUser)

    // nn::Result SetUserPosition(const nn::account::Uid& uid, std::int32_t position) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetUserPosition)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(position, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (position, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(position)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetUserPosition)

    // nn::Result GetProfileEditor(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfileEditor>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileEditor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutProfile, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileEditor)

    // nn::Result CompleteUserRegistrationForcibly(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompleteUserRegistrationForcibly)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompleteUserRegistrationForcibly)

    // nn::Result CreateFloatingRegistrationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateFloatingRegistrationRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutRequest, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutRequest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemory, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemory))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRequest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateFloatingRegistrationRequest)

    // nn::Result AuthenticateServiceAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AuthenticateServiceAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(230)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AuthenticateServiceAsync)

    // nn::Result GetBaasAccountAdministrator(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IAdministrator>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBaasAccountAdministrator)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(250)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBaasAccountAdministrator)

    // nn::Result ProxyProcedureForGuestLoginWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ProxyProcedureForGuestLoginWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(290)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ProxyProcedureForGuestLoginWithNintendoAccount)

    // nn::Result ProxyProcedureForFloatingRegistrationWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ProxyProcedureForFloatingRegistrationWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(291)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ProxyProcedureForFloatingRegistrationWithNintendoAccount)

    // nn::Result SuspendBackgroundDaemon(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendBackgroundDaemon)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(299)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendBackgroundDaemon)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::ProfileDigest), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::SystemProgramIdentification), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::IAccountServiceForAdministrator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::IAccountServiceForAdministrator), (::nn::account::IAccountServiceForSystemService))

    // nn::Result BeginUserRegistration(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginUserRegistration, (::nn::sf::Out<::nn::account::Uid> pOutUid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginUserRegistration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutUid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginUserRegistration)
    }

    // nn::Result CompleteUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistration, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompleteUserRegistration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompleteUserRegistration)
    }

    // nn::Result CancelUserRegistration(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelUserRegistration, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelUserRegistration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelUserRegistration)
    }

    // nn::Result DeleteUser(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUser, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteUser)
    }

    // nn::Result SetUserPosition(const nn::account::Uid& uid, std::int32_t position) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUserPosition, (const ::nn::account::Uid& uid, ::std::int32_t position))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetUserPosition)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(position)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetUserPosition)
    }

    // nn::Result GetProfileEditor(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfileEditor>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileEditor, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::profile::IProfileEditor>> pOutProfile, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileEditor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileEditor)
    }

    // nn::Result CompleteUserRegistrationForcibly(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompleteUserRegistrationForcibly, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompleteUserRegistrationForcibly)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompleteUserRegistrationForcibly)
    }

    // nn::Result CreateFloatingRegistrationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateFloatingRegistrationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IFloatingRegistrationRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateFloatingRegistrationRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateFloatingRegistrationRequest)
    }

    // nn::Result AuthenticateServiceAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateServiceAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AuthenticateServiceAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AuthenticateServiceAsync)
    }

    // nn::Result GetBaasAccountAdministrator(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IAdministrator>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountAdministrator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IAdministrator>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBaasAccountAdministrator)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBaasAccountAdministrator)
    }

    // nn::Result ProxyProcedureForGuestLoginWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForGuestLoginWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ProxyProcedureForGuestLoginWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ProxyProcedureForGuestLoginWithNintendoAccount)
    }

    // nn::Result ProxyProcedureForFloatingRegistrationWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureForFloatingRegistrationWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ProxyProcedureForFloatingRegistrationWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ProxyProcedureForFloatingRegistrationWithNintendoAccount)
    }

    // nn::Result SuspendBackgroundDaemon(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendBackgroundDaemon, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendBackgroundDaemon)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendBackgroundDaemon)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::IAccountServiceForAdministrator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::IAccountServiceForAdministrator), (::nn::account::IAccountServiceForSystemService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginUserRegistration)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutUid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompleteUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompleteUserRegistration)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelUserRegistration)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetUserPosition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetUserPosition)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(position)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileEditor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::profile::IProfileEditor>), pOutProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileEditor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutProfile, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompleteUserRegistrationForcibly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompleteUserRegistrationForcibly)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateFloatingRegistrationRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IFloatingRegistrationRequest>), pOutRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateFloatingRegistrationRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutRequest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutRequest, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AuthenticateServiceAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AuthenticateServiceAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBaasAccountAdministrator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IAdministrator>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBaasAccountAdministrator)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ProxyProcedureForGuestLoginWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ProxyProcedureForGuestLoginWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ProxyProcedureForFloatingRegistrationWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForExternalNsa>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ProxyProcedureForFloatingRegistrationWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendBackgroundDaemon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::ISessionObject>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendBackgroundDaemon)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompleteUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelUserRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetUserPosition)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileEditor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompleteUserRegistrationForcibly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateFloatingRegistrationRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AuthenticateServiceAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBaasAccountAdministrator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ProxyProcedureForGuestLoginWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ProxyProcedureForFloatingRegistrationWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendBackgroundDaemon)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::IAccountServiceForAdministrator))

namespace nn { namespace account { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAccountServiceForApplication, (::nn::account::IAccountServiceBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAccountServiceForApplication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfoV0, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateApplicationAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& imageBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateGuestLoginRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IGuestLoginRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadOpenContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> outPtr0, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenContextStoredUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfo, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAccountServiceForApplication)

        ::nn::Result InitializeApplicationInfoV0(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeApplicationInfoV0, (pid));
        }

        ::nn::Result GetBaasAccountManagerForApplication(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForApplication, (pOut, uid));
        }

        ::nn::Result AuthenticateApplicationAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AuthenticateApplicationAsync, (pOutContext));
        }

        ::nn::Result CheckNetworkServiceAvailabilityAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (pOutContext));
        }

        ::nn::Result StoreSaveDataThumbnail(const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), imageBuffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = imageBuffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (uid, imageBuffer));
        }

        ::nn::Result ClearSaveDataThumbnail(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (uid));
        }

        ::nn::Result CreateGuestLoginRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IGuestLoginRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateGuestLoginRequest, (pOutRequest, ::std::move(workMemory), workMemorySize));
        }

        ::nn::Result LoadOpenContext(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> outPtr0, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadOpenContext, (outPtr0, uid));
        }

        ::nn::Result ListOpenContextStoredUsers(const ::nn::sf::OutArray<::nn::account::Uid>& outUsers) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), outUsers)), "_.GetLength() == ::nn::account::UserCountMax (where _ = outUsers)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListOpenContextStoredUsers, (outUsers));
        }

        ::nn::Result InitializeApplicationInfo(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeApplicationInfo, (pid));
        }

        ::nn::Result ListQualifiedUsers(const ::nn::sf::OutArray<::nn::account::Uid>& outUsers) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), outUsers)), "_.GetLength() == ::nn::account::UserCountMax (where _ = outUsers)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (outUsers));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAccountServiceForApplication : public ::nn::account::IAccountServiceBase
    {
    public:
        nn::Result InitializeApplicationInfoV0(nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result GetBaasAccountManagerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result AuthenticateApplicationAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT;
        nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result CreateGuestLoginRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IGuestLoginRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT;
        nn::Result LoadOpenContext(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> outPtr0, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ListOpenContextStoredUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
        nn::Result InitializeApplicationInfo(nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetUserCount(nn::sf::Out<std::int32_t> pOutCount) NN_NOEXCEPT;
    nn::Result GetUserExistence(nn::sf::Out<bool> pOutExistence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ListAllUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result ListOpenUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result GetLastOpenedUser(nn::sf::Out<nn::account::Uid> pOutUid) NN_NOEXCEPT;
    nn::Result GetProfile(nn::sf::Out<nn::sf::SharedPointer<nn::account::profile::IProfile>> pOutProfile, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileDigest(nn::sf::Out<nn::account::ProfileDigest> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result IsUserRegistrationRequestPermitted(nn::sf::Out<bool> pOut, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result TrySelectUserWithoutInteraction(nn::sf::Out<nn::account::Uid> pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;
    nn::Result DebugActivateOpenContextRetention(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::ISessionObject>> pOut) NN_NOEXCEPT;
    nn::Result InitializeApplicationInfoV0(nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result GetBaasAccountManagerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result AuthenticateApplicationAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT;
    nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CreateGuestLoginRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IGuestLoginRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT;
    nn::Result LoadOpenContext(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> outPtr0, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ListOpenContextStoredUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
    nn::Result InitializeApplicationInfo(nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::IAccountServiceForApplication), (::nn::account::IAccountServiceBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfoV0, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeApplicationInfoV0, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBaasAccountManagerForApplication, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateApplicationAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AuthenticateApplicationAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& imageBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StoreSaveDataThumbnail, (uid, imageBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearSaveDataThumbnail, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGuestLoginRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IGuestLoginRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateGuestLoginRequest, (pOutRequest, ::std::move(workMemory), workMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadOpenContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> outPtr0, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadOpenContext, (outPtr0, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenContextStoredUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListOpenContextStoredUsers, (outUsers));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfo, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeApplicationInfo, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListQualifiedUsers, (outUsers));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::IAccountServiceForApplication>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::IAccountServiceForApplication), (::nn::account::IAccountServiceBase))

    // nn::Result InitializeApplicationInfoV0(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeApplicationInfoV0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeApplicationInfoV0)

    // nn::Result GetBaasAccountManagerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBaasAccountManagerForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBaasAccountManagerForApplication)

    // nn::Result AuthenticateApplicationAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AuthenticateApplicationAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AuthenticateApplicationAsync)

    // nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckNetworkServiceAvailabilityAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckNetworkServiceAvailabilityAsync)

    // nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreSaveDataThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreSaveDataThumbnail)

    // nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearSaveDataThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearSaveDataThumbnail)

    // nn::Result CreateGuestLoginRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IGuestLoginRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateGuestLoginRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutRequest, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutRequest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workMemory, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (workMemory))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workMemorySize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (workMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRequest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateGuestLoginRequest)

    // nn::Result LoadOpenContext(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> outPtr0, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadOpenContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outPtr0, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outPtr0))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPtr0), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadOpenContext)

    // nn::Result ListOpenContextStoredUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListOpenContextStoredUsers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(131)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListOpenContextStoredUsers)

    // nn::Result InitializeApplicationInfo(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeApplicationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(140)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeApplicationInfo)

    // nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListQualifiedUsers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(141)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListQualifiedUsers)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::ProfileDigest), 16, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::IAccountServiceForApplication, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::IAccountServiceForApplication), (::nn::account::IAccountServiceBase))

    // nn::Result InitializeApplicationInfoV0(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfoV0, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeApplicationInfoV0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeApplicationInfoV0)
    }

    // nn::Result GetBaasAccountManagerForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBaasAccountManagerForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBaasAccountManagerForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBaasAccountManagerForApplication)
    }

    // nn::Result AuthenticateApplicationAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AuthenticateApplicationAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AuthenticateApplicationAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AuthenticateApplicationAsync)
    }

    // nn::Result CheckNetworkServiceAvailabilityAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckNetworkServiceAvailabilityAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckNetworkServiceAvailabilityAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckNetworkServiceAvailabilityAsync)
    }

    // nn::Result StoreSaveDataThumbnail(const nn::account::Uid& uid, const nn::sf::InBuffer& imageBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreSaveDataThumbnail, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& imageBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreSaveDataThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreSaveDataThumbnail)
    }

    // nn::Result ClearSaveDataThumbnail(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSaveDataThumbnail, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearSaveDataThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearSaveDataThumbnail)
    }

    // nn::Result CreateGuestLoginRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IGuestLoginRequest>> pOutRequest, nn::sf::NativeHandle&& workMemory, std::uint32_t workMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGuestLoginRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IGuestLoginRequest>> pOutRequest, ::nn::sf::NativeHandle&& workMemory, ::std::uint32_t workMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateGuestLoginRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateGuestLoginRequest)
    }

    // nn::Result LoadOpenContext(nn::sf::Out<nn::sf::SharedPointer<nn::account::baas::IManagerForApplication>> outPtr0, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadOpenContext, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>> outPtr0, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadOpenContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPtr0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadOpenContext)
    }

    // nn::Result ListOpenContextStoredUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListOpenContextStoredUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListOpenContextStoredUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListOpenContextStoredUsers)
    }

    // nn::Result InitializeApplicationInfo(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeApplicationInfo, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeApplicationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeApplicationInfo)
    }

    // nn::Result ListQualifiedUsers(const nn::sf::OutArray<nn::account::Uid>& outUsers) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListQualifiedUsers, (const ::nn::sf::OutArray<::nn::account::Uid>& outUsers))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListQualifiedUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListQualifiedUsers)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::IAccountServiceForApplication>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::IAccountServiceForApplication), (::nn::account::IAccountServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeApplicationInfoV0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeApplicationInfoV0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBaasAccountManagerForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBaasAccountManagerForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AuthenticateApplicationAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AuthenticateApplicationAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckNetworkServiceAvailabilityAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckNetworkServiceAvailabilityAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreSaveDataThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearSaveDataThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateGuestLoginRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IGuestLoginRequest>), pOutRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateGuestLoginRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutRequest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workMemory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutRequest, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadOpenContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::baas::IManagerForApplication>), outPtr0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadOpenContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outPtr0),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outPtr0, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListOpenContextStoredUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListOpenContextStoredUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeApplicationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListQualifiedUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::UserCountMax), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListQualifiedUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeApplicationInfoV0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBaasAccountManagerForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AuthenticateApplicationAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckNetworkServiceAvailabilityAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearSaveDataThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateGuestLoginRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadOpenContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListOpenContextStoredUsers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListQualifiedUsers)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::IAccountServiceForApplication))

namespace nn { namespace account { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBaasAccessTokenAccessor, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBaasAccessTokenAccessor)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnsureCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceAccountId, (::nn::sf::Out<::std::uint64_t> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid, const ::nn::npns::NotificationToken& nt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBaasAccessTokenAccessor)

        ::nn::Result EnsureCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnsureCacheAsync, (pOutContext, uid));
        }

        ::nn::Result LoadCache(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadCache, (pOutActualSize, pOut, uid));
        }

        ::nn::Result GetDeviceAccountId(::nn::sf::Out<::std::uint64_t> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceAccountId, (pOut, uid));
        }

        ::nn::Result RegisterNotificationTokenAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid, const ::nn::npns::NotificationToken& nt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterNotificationTokenAsync, (pOutContext, uid, nt));
        }

        ::nn::Result UnregisterNotificationTokenAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterNotificationTokenAsync, (pOutContext, uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBaasAccessTokenAccessor
    {
    public:
        nn::Result EnsureCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result LoadCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetDeviceAccountId(nn::sf::Out<std::uint64_t> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result RegisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid, const nn::npns::NotificationToken& nt) NN_NOEXCEPT;
        nn::Result UnregisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result EnsureCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetDeviceAccountId(nn::sf::Out<std::uint64_t> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RegisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid, const nn::npns::NotificationToken& nt) NN_NOEXCEPT;
    nn::Result UnregisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::IBaasAccessTokenAccessor))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnsureCacheAsync, (pOutContext, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadCache, (pOutActualSize, pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceAccountId, (::nn::sf::Out<::std::uint64_t> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceAccountId, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid, const ::nn::npns::NotificationToken& nt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterNotificationTokenAsync, (pOutContext, uid, nt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterNotificationTokenAsync, (pOutContext, uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::IBaasAccessTokenAccessor>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::IBaasAccessTokenAccessor))

    // nn::Result EnsureCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureCacheAsync)

    // nn::Result LoadCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadCache)

    // nn::Result GetDeviceAccountId(nn::sf::Out<std::uint64_t> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceAccountId)

    // nn::Result RegisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid, const nn::npns::NotificationToken& nt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterNotificationTokenAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(nt, (::nn::npns::NotificationToken), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (nt, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterNotificationTokenAsync)

    // nn::Result UnregisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterNotificationTokenAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterNotificationTokenAsync)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::npns::NotificationToken), 40, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::IBaasAccessTokenAccessor, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::IBaasAccessTokenAccessor))

    // nn::Result EnsureCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureCacheAsync)
    }

    // nn::Result LoadCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadCache)
    }

    // nn::Result GetDeviceAccountId(nn::sf::Out<std::uint64_t> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceAccountId, (::nn::sf::Out<::std::uint64_t> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceAccountId)
    }

    // nn::Result RegisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid, const nn::npns::NotificationToken& nt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid, const ::nn::npns::NotificationToken& nt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterNotificationTokenAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterNotificationTokenAsync)
    }

    // nn::Result UnregisterNotificationTokenAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNotificationTokenAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterNotificationTokenAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterNotificationTokenAsync)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::IBaasAccessTokenAccessor>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::IBaasAccessTokenAccessor))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterNotificationTokenAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterNotificationTokenAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(nt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterNotificationTokenAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterNotificationTokenAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterNotificationTokenAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterNotificationTokenAsync)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::IBaasAccessTokenAccessor))
