﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Net;
using System.Text.RegularExpressions;
using System.Threading.Tasks.Dataflow;
using Nintendo.Foundation.IO;

namespace Nintendo.WriteSerialNumber
{
    public class Argument
    {
        [CommandLineOption("target", IsRequired = true,
            Description = "Specify the target.")]
        public string Target { get; set; }

        [CommandLineOption("skip-connection",
            Description = "Skip connection to Target.")]
        public bool SkipConnection { get; set; }

        [CommandLineOption("write-name",
            Description = "Write serial numeber to HostBridge name too.")]
        public bool WriteName { get; set; }

        [CommandLineOption('v', "verbose",
            Description = "Output trace logs.")]
        public bool Verbose { get; set; }
    }
}
