﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading.Tasks.Dataflow;
using Nintendo.Foundation.IO;
using Nintendo.ControlTarget;
using System.Threading;
using System.Globalization;

namespace Nintendo.RunOnTarget
{
    public class CommandInterfacePrivate
    {
        public static int Main(string[] rawArgs)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo("en", true);
#if !DEBUG
            try
            {
#endif
                NnRunCommandArgumentRaw parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<NnRunCommandArgumentRaw>(rawArgs, out parsed))
                {
                    return 1;
                }
                else if (parsed.Run != null)
                {
                    DataflowConsole.Instance.SetOption(parsed.Run.Verbose);
                    ConsoleApplicationTraceListener.SetGlobal(parsed.Run.Verbose);

                    var args = new RunCommandArgumentPrivate(parsed.Run);
                    return Run(args);
                }
                else
                {
                    throw new InvalidUsage("Unknown command");
                }
#if !DEBUG
            }
            catch (Exception exception)
            {
                PrintException(exception);
                return 1;
            }
#endif
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Trace.WriteLine($"StackTrace: {exception.StackTrace}");
        }

        public static int Run(RunCommandArgumentPrivate args)
        {
            return new RunnerPrivate().Run(args, args.ExtraTargetManagerDirectory) == ExitStatus.Success ? 0 : 1;
        }
    }
}
