﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Text.RegularExpressions;
using Nintendo.ControlTarget;

namespace Nintendo.RunOnTarget
{
    public enum ExitStatus
    {
        Success,
        Failure
    }

    public class ExitCondition
    {
        public bool NoWait { get; set; }
        public TimeSpan SuccessTimeOut { get; set; }
        public TimeSpan FailureTimeOut { get; set; }
        public Regex SuccessExitPattern { get; set; }
        public Regex FailureExitPattern { get; set; }
        public List<Regex> NotFoundFailurePatterns { get; set; }
        public Regex SuccessTimeOutResetPattern { get; set; }
        public Regex FailureTimeOutResetPattern { get; set; }
        public bool WaitExitProcess { get; set; }
        public Task<int> TargetProcessCompletion { get; set; }
        public static readonly Regex NeverMatchedRegex = new Regex("$^");

        public ExitCondition()
        {
            NoWait = false;
            SuccessTimeOut = TimeSpan.MaxValue;
            FailureTimeOut = TimeSpan.MaxValue;
            SuccessExitPattern = NeverMatchedRegex;
            FailureExitPattern = NeverMatchedRegex;
            SuccessTimeOutResetPattern = NeverMatchedRegex;
            FailureTimeOutResetPattern = NeverMatchedRegex;
            NotFoundFailurePatterns = new List<Regex>();
            WaitExitProcess = true;
        }

        public ExitCondition(bool noWait, string[] successExitPatterns, string[] failureExitPatterns, int successTimeOut, int failureTimeOut, string[] successTimeOutResetPatterns, string[] failureTimeOutResetPatterns, string[] notFoundFailurePatterns, bool waitExitProcess)
        {
            NoWait = noWait;
            SuccessExitPattern = successExitPatterns == null ? ExitCondition.NeverMatchedRegex : new Regex(Utility.MakeJoinedPattern(successExitPatterns));
            FailureExitPattern = failureExitPatterns == null ? ExitCondition.NeverMatchedRegex : new Regex(Utility.MakeJoinedPattern(failureExitPatterns));
            SuccessTimeOut = successTimeOut == -1 ? TimeSpan.MaxValue : TimeSpan.FromSeconds(successTimeOut);
            FailureTimeOut = failureTimeOut == -1 ? TimeSpan.MaxValue : TimeSpan.FromSeconds(failureTimeOut);
            SuccessTimeOutResetPattern = successTimeOutResetPatterns == null ? ExitCondition.NeverMatchedRegex : new Regex(Utility.MakeJoinedPattern(successTimeOutResetPatterns));
            FailureTimeOutResetPattern = failureTimeOutResetPatterns == null ? ExitCondition.NeverMatchedRegex : new Regex(Utility.MakeJoinedPattern(failureTimeOutResetPatterns));
            NotFoundFailurePatterns = notFoundFailurePatterns == null ? new List<Regex>() : (from pattern in notFoundFailurePatterns select new Regex(pattern)).ToList();
            WaitExitProcess = waitExitProcess;
        }
    }
}
