﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Net;
using System.Text.RegularExpressions;
using Nintendo.Foundation.IO;

namespace Nintendo.RecoveryBoot
{
    public class Argument
    {
        [CommandLineOption("target", IsRequired = true,
            Description = "Specify the target.")]
        public string Target { get; set; }

        [CommandLineOption("image", IsRequired = true,
            Description = "Specify the upload image.")]
        public string FirmwareImagePath { get; set; }

        [CommandLineOption('v', "verbose",
            Description = "Output trace logs.")]
        public bool Verbose { get; set; }
    }

}
