﻿namespace Nintendo.NintendoSdkServiceManager
{
    using System.IO;
    internal class NintendoSdkRootMarkFinder
    {
        public static string Find()
        {
            const string RootMarkFile = "NintendoSdkRootMark";
            var path = System.Reflection.Assembly.GetExecutingAssembly().Location;
            var current = path;
            var root = Path.GetPathRoot(path);
            while (root != current)
            {
                var rootMarkFilePath = Path.Combine(current, RootMarkFile);
                if (File.Exists(rootMarkFilePath))
                {
                    return current;
                }
                current = Path.GetFullPath(Path.Combine(current, ".."));
            }
            throw new FileNotFoundException(RootMarkFile + " file is not found @ " + path);
        }
    }
}
