﻿namespace Nintendo.NintendoSdkServiceLauncher
{
    using System;
    using Nintendo.Foundation.IO;
    internal class ConsoleApplication
    {
        public void Run(string[] args)
        {
            try
            {
                var parser = new CommandLineParser();
                Argument parsed;
                if (false == parser.ParseArgs<Argument>(args, out parsed))
                {
                    var message = "[ERROR] Cannot parse command line args.";
                    throw new Exception(message);
                }
                else if (parsed.Start != null)
                {
                    Start();
                }
                else if (parsed.Stop != null)
                {
                    Stop();
                }
                else
                {
                    var message = "[ERROR] Unknown command line args.";
                    throw new Exception(message);
                }
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine(exception.Message);
                Console.Error.WriteLine(exception.StackTrace);
                throw;
            }
        }

        private void Start()
        {
            var path = FindServiceManager();
            StartProcessWithoutWindow(path, "start");
        }

        private void Stop()
        {
            var path = FindServiceManager();
            StartProcessWithoutWindow(path, "stop");
        }

        private static void StartProcessWithoutWindow(string path, string args)
        {
            System.Diagnostics.ProcessStartInfo info = new System.Diagnostics.ProcessStartInfo(path);
            info.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
            info.Arguments = args;
            var p = System.Diagnostics.Process.Start(info);
            p.WaitForExit();
        }

        private static string FindServiceManager()
        {
            var sdkRootPath = string.Empty;

            // TODO: となりにある NintendoSdkServiceLauncher.txt から探す (必要になってから実装する)

            // NintendoSdkRootMark ファイルを探す
            if (string.IsNullOrEmpty(sdkRootPath))
            {
                try
                {
                    var result = NintendoSdkServiceManager.NintendoSdkRootMarkFinder.Find();
                    if (VerifySdkServiceManagerPath(result))
                    {
                        sdkRootPath = result;
                    }
                }
                catch (System.IO.FileNotFoundException)
                {
                    // なにもしない (数行下の環境変数を探す処理に入る)
                }
            }

            // 環境変数 NINTENDO_SDK_ROOT を探す
            if (string.IsNullOrEmpty(sdkRootPath))
            {
                var result = Environment.GetEnvironmentVariable("NINTENDO_SDK_ROOT");
                if (VerifySdkServiceManagerPath(result))
                {
                    sdkRootPath = result;
                }
            }

            if (string.IsNullOrEmpty(sdkRootPath))
            {
                var message = "[ERROR] Cannot specify NintendoSDK path.";
                throw new Exception(message);
            }

            return System.IO.Path.Combine(sdkRootPath, ServiceManagerPath);
        }

        private static readonly string ServiceManagerPath = @"Tools\CommandLineTools\NintendoSdkServiceManager.exe";

        private static bool VerifySdkServiceManagerPath(string sdkRootPath)
        {
            var fullPath = System.IO.Path.Combine(sdkRootPath, ServiceManagerPath);
            return System.IO.File.Exists(fullPath);
        }

        private class Argument
        {
            [CommandLineSubCommand("start", Description = "start NintendoSDK service processes.")]
            public StartCommand Start { get; set; }

            [CommandLineSubCommand("stop", Description = "stop NintendoSDK service processes.")]
            public StopCommand Stop { get; set; }
        }

        private class StartCommand
        {
        }

        private class StopCommand
        {
        }
    }
}
