﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeEdev
{
    public partial class LogForm : Form
    {
        public string FirmwareVersion = null;
        public string EdevSerialNumber = null;
        private Nintendo.InitializeSdev.StringReaderWriter LogStringWriter = new Nintendo.InitializeSdev.StringReaderWriter();
        private Nintendo.InitializeSdev.StringReaderWriter ErrorLogStringWriter = new Nintendo.InitializeSdev.StringReaderWriter();
        private int UpdatePercentage = 0;
        private const int progressBeforeInitializeEdev = 10;

        public LogForm()
        {
            InitializeComponent();
        }

        private void LogForm_Load(object sender, EventArgs e)
        {
            this.UpdateProgressBar.Minimum = 0;
            this.UpdateProgressBar.Maximum = 100;
            this.UpdateProgressBar.Value = 0;
            this.LogTextBox.Clear();
            this.ResultLabel.Text = string.Empty;

            Console.SetOut(LogStringWriter);
            Console.SetError(ErrorLogStringWriter);
            LogUpdateTimer.Interval = 1000;
            LogUpdateTimer.Enabled = true;

            ExitButton.Enabled = false;

            BackgroundUpdateWorker.WorkerReportsProgress = true;
            BackgroundUpdateWorker.RunWorkerAsync();
        }

        private void BackgroundUpdateWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = (BackgroundWorker)sender;
            // ExitStatus eStatus;

            worker.ReportProgress(0);

            MainForm mf = (MainForm)this.Owner;
            // eStatus = HostBridgeFirmwareAccessor.UpdateHostBridgeFirmware(ref hbControl, SdevMacAddress, FirmwareVersion);
            // if (eStatus != ExitStatus.Success)
            // {
            //     e.Cancel = true;
            //     return;
            // }

            // UpdateHostBridgeFinished = true;
            worker.ReportProgress(progressBeforeInitializeEdev);

            List<string> args1;
            args1 = new List<string>() { "--target-serial", EdevSerialNumber, "--verbose" };
            // args1.Add("--disable-hostbridge-fw-update");
            if (FirmwareVersion != null)
            {
                args1.Add("--target-version");
                args1.Add(FirmwareVersion);
            }

            List<string> argsList = new List<string>();
            argsList.AddRange(args1);

            InitializeSdev.ProcessAccessor.DumpProcessArgumentList("InitializeEdev", argsList);

            int retVar = Nintendo.InitializeEdev.CommandInterface.Main(argsList.ToArray());

            e.Result = retVar;
            worker.ReportProgress(100);
        }

        private void LogForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }

        private void LogTextBox_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.A)
            {
                LogTextBox.SelectAll();
            }
        }

        private void ExitButton_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void LogUpdateTimer_Tick(object sender, EventArgs e)
        {
            this.LogTextBox.AppendText(LogStringWriter.ReadCurrent());
            this.LogTextBox.AppendText(ErrorLogStringWriter.ReadCurrent());
            Nintendo.InitializeSdev.ProcessingProgress progress = Nintendo.InitializeSdev.ProcessingProgress.GetInstance();
            BackgroundWorker worker = this.BackgroundUpdateWorker;
            int percentage = progressBeforeInitializeEdev;
            percentage += progress.GetProgress() * (100 - progressBeforeInitializeEdev) / 100;
            if (percentage != UpdatePercentage)
            {
                if (LogUpdateTimer.Enabled)      // 念のため入れておく。本来は不要
                {
                    worker.ReportProgress(percentage);
                }
                UpdatePercentage = percentage;
            }
        }

        private void BackgroundUpdateWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.UpdateProgressBar.Value = e.ProgressPercentage;
        }

        private void BackgroundUpdateWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            LogUpdateTimer.Enabled = false;

            this.LogTextBox.AppendText(LogStringWriter.ReadCurrent());
            this.LogTextBox.AppendText(ErrorLogStringWriter.ReadCurrent());
            if (e.Cancelled || e.Error != null)
            {
                this.ResultLabel.ForeColor = Color.Red;
                this.ResultLabel.Text = "Fail";
            }
            else if ((int)e.Result == 0)
            {
                this.ResultLabel.ForeColor = Color.LimeGreen;
                this.ResultLabel.Text = "Success";
            }
            else
            {
                this.ResultLabel.ForeColor = Color.Red;
                this.ResultLabel.Text = "Fail";
            }
            SaveLogFile.Write(this.LogTextBox.Text);
            ExitButton.Enabled = true;
        }
    }
}
