﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.ControlTarget;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeEdev
{
    public class TargetSpecifier
    {
#if false
        private HostBridgeController m_Handle;

        private TargetSpecifier()
        {
            m_Handle = null;
        }

        public TargetSpecifier(HostBridgeController handle)
        {
            m_Handle = handle;
        }

        public void SetHandle(HostBridgeController handle)
        {
            m_Handle = handle;
        }

        public void Release()
        {
            m_Handle.Release();
        }
#endif
        public static bool IsExistTarget(InitializeSdev.TargetInnerClass targetKey, EdevInitializeCommandArgument.TargetArgumentType taragetArgumentType, string targetManagerDirectory)
        {
            Nintendo.InitializeSdev.SerialNumber serial = new InitializeSdev.SerialNumber(targetKey.Value);
            if (serial.GetString() == null)
            {
                return false;
            }
            string targetString = serial.GetStringWithCheckDigit();

            using (var tmapiAccessor = new TargetManagerAccessor())
            {
                tmapiAccessor.SetExtraTargetManagerDirectory(targetManagerDirectory);
                tmapiAccessor.EnsureStart();

                TimeSpan restTime = TimeSpan.FromSeconds(30);
                while (0 < restTime.TotalMilliseconds)
                {
                    var waitTime = TimeSpan.FromMilliseconds(Math.Min(restTime.TotalMilliseconds, 2000.0));

                    if (tmapiAccessor.DetectTarget(targetString, waitTime) != null)
                    {
                        LOG.LogLine(LOG_LEVEL.LOG_INFO2, "Found the target. name = {0}", targetString);
                        return true;
                    }

                    restTime -= waitTime;
                }

                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Found no targets. name = {0}", targetString);
                return false;
            }
        }

        public static string GetTargetSerialFromName(string targetName, string targetManagerDirectory)
        {
            using (var tmapiAccessor = new TargetManagerAccessor())
            {
                tmapiAccessor.SetExtraTargetManagerDirectory(targetManagerDirectory);
                tmapiAccessor.EnsureStart();

                TimeSpan restTime = TimeSpan.FromSeconds(30);
                while (0 < restTime.TotalMilliseconds)
                {
                    var waitTime = TimeSpan.FromMilliseconds(Math.Min(restTime.TotalMilliseconds, 2000.0));

                    Nintendo.ControlTarget.Tmapi.TargetInfo targetInfo = tmapiAccessor.DetectTarget(targetName, waitTime);
                    if (targetInfo != null)
                    {
                        return targetInfo.GetSerialNumber();
                    }

                    restTime -= waitTime;
                }

                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Found no targets. name = {0}", targetName);
                return null;
            }
        }

        public static bool GetTargetKey(ref InitializeSdev.TargetInnerClass targetKey, string targetArgumentString, EdevInitializeCommandArgument.TargetArgumentType taragetArgumentType, string targetManagerDirectory)
        {
            switch (taragetArgumentType)
            {
                case EdevInitializeCommandArgument.TargetArgumentType.TypeSerial:
                    Nintendo.InitializeSdev.SerialNumber serial = new InitializeSdev.SerialNumber(targetArgumentString);
                    if(serial.GetString() == null)
                    {
                        LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Invalid serial number ({0}).", targetArgumentString);
                        return false;
                    }
                    targetKey.Set(serial.GetString(), InitializeSdev.TargetInnerClass.TargetType.TargetInner_EdevSerial);
                    break;
                case EdevInitializeCommandArgument.TargetArgumentType.TypeName:
                    string serialString = GetTargetSerialFromName(targetArgumentString, targetManagerDirectory);
                    if (serialString == null)
                    {
                        LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Invalid name ({0}).", targetArgumentString);
                        return false;
                    }
                    Nintendo.InitializeSdev.SerialNumber serial2 = new InitializeSdev.SerialNumber(serialString);
                    targetKey.Set(serial2.GetString(), InitializeSdev.TargetInnerClass.TargetType.TargetInner_EdevSerial);
                    break;
                default:
                    LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Unsupported target argument : {0}", targetArgumentString);
                    return false;
            }

#if false
            if (!IsExistTarget(targetArgumentString, taragetArgumentType, targetManagerDirectory))
            {
                return false;
            }
#endif

            return true;
        }


        public enum EdevVersion
        {
            EDEV_EP_2_1,
            EDEV_EP_2_2,
            EDEV_MP,
            EDEV_NONE,
            EDEV_ERROR
        };

        public static InitializeSdev.TargetSpecifier.SdevVersion GetDevkitVersion(EdevVersion version)
        {
            switch(version)
            {
                case EdevVersion.EDEV_EP_2_1:
                    return InitializeSdev.TargetSpecifier.SdevVersion.EDEV_EP_2_1;
                case EdevVersion.EDEV_EP_2_2:
                    return InitializeSdev.TargetSpecifier.SdevVersion.EDEV_EP_2_2;
                case EdevVersion.EDEV_MP:
                    return InitializeSdev.TargetSpecifier.SdevVersion.EDEV_MP;
                case EdevVersion.EDEV_NONE:
                    return InitializeSdev.TargetSpecifier.SdevVersion.SDEV_NONE;
                default:
                    return InitializeSdev.TargetSpecifier.SdevVersion.SDEV_ERROR;
            }
        }

    }
}
