﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ControlTarget
{
    public class GetTargetInformation
    {
        public string Execute(GetTargetInformationCommand arguments)
        {
            if (arguments.Target == null)
            {
                throw new Exception("Target was not specified");
            }

            var ret = new StringBuilder();

            using (var tmHandle = new TargetManagerAccessor())
            {
                tmHandle.EnsureStart();

                var targetInfo = tmHandle.GetTargetInfo(arguments.Target);
                ret.AppendLine("ConnectionType=" + targetInfo.GetConnectionType());
                ret.AppendLine("HardwareType=" + targetInfo.GetHardwareType());
                ret.AppendLine("IpAddress=" + targetInfo.GetIpAddress());
                ret.AppendLine("MacAddress=" + targetInfo.GetMacAddress());
                ret.AppendLine("Name=" + targetInfo.GetName());
                ret.AppendLine("SerialNumber=" + targetInfo.GetSerialNumber());
                ret.AppendLine("TmaVersion=" + targetInfo.GetTmaVersion());
            }

            return ret.ToString().TrimEnd();
        }
    }
}
