﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

using namespace System;

namespace Nintendo {
namespace ControlTarget {
namespace Tmapi {

    public enum class TmapiError
    {
        Error_Ok,                             ///< No error.

        Error_GenericRangeBegin                = 1,
        Error_Unknown,                         ///< Unknown error.
        Error_Timeout,                         ///< Timeout.
        Error_NoConnection,                    ///< No connection to Target Manager service.
        Error_IncompatibleProtocol,            ///< Target Manager protocol version incompatible.
        Error_InvalidOpcode,                   ///< Invalid protocol opcode.
        Error_TargetBusy,                      ///< The requested target is busy.
        Error_TargetUnavailable,               ///< Active target no longer available.
        Error_InvalidAddress,                  ///< Invalid memory address.
        Error_ExecutableNotFound,              ///< Requested executable file was not found.
        Error_InvalidTarget,                   ///< Invalid target specified.
        Error_InvalidProcess,                  ///< Invalid process specified.
        Error_InvalidResponse,                 ///< Invalid value returned.
        Error_TargetDuplicated,                ///< Target already exists.
        Error_InvalidParameter,                ///< One of the parameter(s) is invalid.
        Error_InvalidDeviceHandle,             ///< The HID handle is invalid.
        Error_InvalidController,               ///< The controller index is invalid.
        Error_ExecutableNotCompatible,         ///< The executable file is not compatible with the hardware.
        Error_BufferTooSmall,                  ///< A provided buffer is too small.
        Error_InternalError,                   ///< An "internal error" occurred.
        Error_Cancelled,                       ///< Operation cancelled.
        Error_ConnectVersionError,             ///< Incorrect version connection problem
        Error_ConnectFailed,                   ///< Connect failure due to unknown reason.
        Error_NotImplemented,                  ///< An API or feature is not implemented.
        Error_IncompatibleTmApiVersion,        ///< The client and Target Manager API versions are not compatible.
        Error_DebuggingUnavailable,            ///< Debugging service isn't available.
        Error_NotBackwardsCompatible,          ///< The packet failed to send because the specified task is not backwards compatible an older target, i.e. the target is not up to date with this version of Target Manager.
        Error_ServiceUnavailable,              ///< The service that handles this isn't available.
        Error_TargetDiscoveryAlreadyStarted,   ///< Target discovery has already started.
        Error_ConnectFailedLogServer,          ///< The connect failed because LogServer is unavailable
        Error_TargetIOSearchComplete,          ///< The target IO search is finished, we have found all there is to find.
        Error_TargetIOInsufficientSpace,       ///< Not enough space on the memory card.
        Error_TargetIONoMemoryCard,            ///< No memory card inserted in the device.
        Error_TargetIOPathAlreadyExists,       ///< Path already exists on the memory card.
        Error_TargetIOMemoryCardError,         ///< Problem reading the memory card.
        Error_TargetAsleep,                    ///< Target is asleep.
        Error_NoProcessLoaded,                 ///< No process is loaded to the target.
        Error_IncompatibleTargetManager,       ///< This function is not implemented in the detected version of Target Manager. This can occur if client code is attempting to call a new function on an older version of Targer Manager.
        Error_GenericRangeEnd                  = 100,

        Error_ProcessRangeBegin                = Error_GenericRangeEnd,
        Error_ProcessStartFailed,              ///< Failed to StartProcess.
        Error_ProcessNotLoaded,                ///< Data has not finished loading.
        Error_ProcessInvalidArguments,         ///< Invalid process arguments.
        Error_ProcessCreateFailed,             ///< Failed to create a process with path.
        Error_ProcessIsRunning,                ///< Process already running.
        Error_ProcessNotRunning,               ///< Desired Process is not running.
        Error_ProcessNotHalted,                ///< Process not halted.
        Error_ProcessAlreadyStarted,           ///< Process already started.
        Error_ProcessHalted,                   ///< Process halted.
        Error_ProcessUnknownRegister,          ///< Unknown register.
        Error_ProcessAttachFailed,             ///< Failed to attach to a process by program Id.
        Error_ProcessNotStarted,               ///< Process hasn't been started yet.
        Error_ProcessDebuggingDisabled,        ///< Debugging is disabled for this process.
        Error_ProcessPackageIncomplete,        ///< A file is missing from the EXE.

        Error_ProcessRangeEnd                  = 200,
    };

    public ref class TmapiException : Exception
    {
    public:
        TmapiException( TmapiError tmapiError )
            : m_TmapiError( tmapiError ), Exception()
        {
        }

        TmapiException( TmapiError tmapiError, String^ message )
            : m_TmapiError( tmapiError ), Exception( message )
        {
        }

        TmapiException( TmapiError tmapiError, String^ message, Exception^ inner )
            : m_TmapiError( tmapiError ), Exception( message, inner )
        {
        }

        TmapiError GetTmapiError()
        {
            return m_TmapiError;
        }

    private:
        TmapiError m_TmapiError;
    };

}
}
}
