﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace Nintendo.ControlTarget
{
    public interface IResetController
    {
        void Reset();
    }

    public interface IResetControllerData
    {
        int Priority { get; }
        string ResetType { get; }
    }

    public class ResetController
    {
        private CompositionContainer Container;

        [ImportMany]
        private IEnumerable<Lazy<IResetController, IResetControllerData>> ResetControllers = null;

        public ResetController()
        {
            var catalog = new AggregateCatalog();
            catalog.Catalogs.Add(new AssemblyCatalog(typeof(ResetController).Assembly));
            catalog.Catalogs.Add(new DirectoryCatalog(System.IO.Path.GetDirectoryName(typeof(ResetController).Assembly.Location)));
            Container = new CompositionContainer(catalog);
            Container.ComposeParts(this);
        }

        public void Reset()
        {
            var sortedResetControllers = new List<Lazy<IResetController, IResetControllerData>>(ResetControllers);
            sortedResetControllers.Sort((a, b) => { return a.Metadata.Priority - b.Metadata.Priority; });

            if (sortedResetControllers.Count <= 0)
            {
                throw new Exception("Found no reset controller");
            }

            var resetController = sortedResetControllers[0];

            resetController.Value.Reset();
        }
    }
}
