﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ControlTarget
{
    public class ListServiceCommandArgument : CommandCommon
    {
        public override void Run()
        {
            RunCommand(
                () =>
                {
                    Console.WriteLine(Nintendo.ControlTarget.ListServiceCommand.Run(false));
                });
        }
    }

    public class ListServiceAllCommandArgument : CommandCommon
    {
        public override void Run()
        {
            RunCommand(
                () =>
                {
                    Console.WriteLine(Nintendo.ControlTarget.ListServiceCommand.Run(true));
                });
        }
    }

    public class ListServiceCommand
    {
        public static string Run(bool enableSystemPort)
        {
            using (var htcDaemonAccessor = new TargetManagerAccessor())
            {
                htcDaemonAccessor.EnsureStart();

                var services = htcDaemonAccessor.ListService();

                var ret = new StringBuilder();

                foreach (var service in services)
                {
                    if (!enableSystemPort && service.ServiceName.StartsWith(Utility.HtcsSystemPortPrefix))
                    {
                        continue;
                    }

                    ret.AppendLine(string.Format("{0}\t{1}\t{2}\t{3}",
                        string.IsNullOrEmpty(service.TargetName) ? "<NoName>" : service.TargetName,
                        string.IsNullOrEmpty(service.TargetId) ? "<NoId>" : service.TargetId,
                        service.ServiceName,
                        service.EndPoint.ToString()));
                }

                return ret.ToString().TrimEnd();
            }
        }
    }
}
