﻿using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class LaunchApplicationCommand : CommonDevMenuCommandCommand
    {
        [CommandLineValue(0, ValueName = "Application id", Description = "Specifies Application ID to launch.")]
        public string ApplicationId { get; set; }

        public override void Run()
        {
            RunDevMenuCommandCommand(() => {
                RunDevMenuCommand(
                    "application",
                    "launch",
                    ApplicationId);
            });
        }
    }
}
