﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class ControlTargetArgument
    {
        [CommandLineSubCommand("set-default", Description = "set the default target.")]
        public SetDefaultCommand SetDefaultCommand { get; set; }

        [CommandLineSubCommand("get-default", Description = "get the default target.")]
        public GetDefaultCommand GetDefaultCommand { get; set; }

        [CommandLineSubCommand("connect", Description = "connect the target.")]
        public ConnectCommand ConnectCommand { get; set; }

        [CommandLineSubCommand("disconnect", Description = "disconnect the target.")]
        public DisconnectCommand DisconnectCommand { get; set; }

        [CommandLineSubCommand("reset", Description = "reset the target.")]
        public ResetCommand ResetCommand { get; set; }

        [CommandLineSubCommand("power-on", Description = "Power on the target.")]
        public PowerOnCommand PowerOnCommand { get; set; }

        [CommandLineSubCommand("power-off", Description = "Power off the target.")]
        public PowerOffCommand PowerOffCommand { get; set; }

        [CommandLineSubCommand("terminate", Description = "Terminate applications running on the target.")]
        public TerminateCommandArgument TerminateCommand { get; set; }

        [CommandLineSubCommand("list-service", Description = "List htcs services.")]
        public ListServiceCommandArgument ListServiceCommand { get; set; }

        [CommandLineSubCommand("list-target", Description = "List registered targets.")]
        public ListTargetCommandArgument ListTargetCommand { get; set; }

        [CommandLineSubCommand("detect-target", Description = "List detected targets.")]
        public ListDetectedTargetCommand ListDetectedTargetCommand { get; set; }

        [CommandLineSubCommand("find-target", Description = "Find all targets that can receive the limited broadcast.")]
        public FindTargetCommand FindTargetCommand { get; set; }

        [CommandLineSubCommand("register", Description = "Register a targets.")]
        public RegisterCommand RegisterCommand { get; set; }

        [CommandLineSubCommand("unregister", Description = "Unregister a targets.")]
        public UnregisterCommand UnregisterCommand { get; set; }

        [CommandLineSubCommand("unregister-all", Description = "Unregister all targets.")]
        public UnregisterAllCommand UnregisterAllCommand { get; set; }

        [CommandLineSubCommand("set-name", Description = "Set a name of the target. If the name is empty, set the default name.")]
        public SetNameCommand SetNameCommand { get; set; }

        [CommandLineSubCommand("wait-detect", Description = "Wait the target to be detected.")]
        public WaitDetectCommand WaitDetectCommand { get; set; }

        [CommandLineSubCommand("set-ip", Description = "Set IP address of the target for debugging.")]
        public SetIpCommand SetIpCommand { get; set; }

        [CommandLineSubCommand("devmenu", Description = "Run DevMenuCommand.\nExample: ControlTarget.exe devmenu -- application list\nShow commands: ControlTarget.exe devmenu -- --help")]
        public DevMenuCommand DevMenuCommand { get; set; }

        [CommandLineSubCommand("firmware-version", Description = "Show firmware version of the target.")]
        public FirmwareVersionCommand FirmwareVersionCommand { get; set; }

        [CommandLineSubCommand("launch-application", Description = "Launch an application.")]
        public LaunchApplicationCommand LaunchApplicationCommand { get; set; }

        [CommandLineSubCommand("list-application", Description = "List installed applications.")]
        public ListApplicationCommand ListApplicationCommand { get; set; }

        [CommandLineSubCommand("install-application", Description = "Install an application.")]
        public InstallApplicationCommand InstallApplicationCommand { get; set; }

        [CommandLineSubCommand("uninstall-application", Description = "Uninstall an application.")]
        public UninstallApplicationCommand UninstallApplicationCommand { get; set; }

        [CommandLineSubCommand("list-savedata", Description = "List savedatas.")]
        public ListSavedataCommand ListSavedataCommand { get; set; }

        [CommandLineSubCommand("delete-savedata", Description = "Delete a savedata.")]
        public DeleteSavedataCommand DeleteSavedataCommand { get; set; }

        [CommandLineSubCommand("delete-all-savedata", Description = "Delete all savedatas.")]
        public DeleteSavedataAllCommand DeleteSavedataAllCommand { get; set; }

        [CommandLineSubCommand("count-pairing-controller", Description = "Count paired contollers.")]
        public CountPairingControllerCommand CountPairingControllerCommand { get; set; }

        [CommandLineSubCommand("delete-all-pairing-controller", Description = "Delete all paired controllers.")]
        public DeleteAllPairingControllerCommand DeleteAllPairingControllerCommand { get; set; }

        [CommandLineSubCommand("batch-devmenu", Description = "Run DevMenuCommand batch.")]
        public BatchDevMenuCommand BatchDevMenuCommand { get; set; }

        [CommandLineSubCommand("enable-cradle", Description = "Enable the cradle connection.")]
        public EnableCradleCommand EnableDetachCradleCommand { get; set; }

        [CommandLineSubCommand("disable-cradle", Description = "Disable the cradle connection.")]
        public DisableCradleCommand DisableDetachCradleCommand { get; set; }

        [CommandLineSubCommand("press-power-button", Description = "Press targe power button using SDEV power button emulation feature.")]
        public PressPowerButtonCommand PressPowerButtonCommand { get; set; }

        [CommandLineSubCommand("set-battery-level", Description = "Set a battery level.")]
        public SetBatteryLevelCommand SetBatteryLevelCommand { get; set; }

        [CommandLineSubCommand("take-screenshot", Description = "Take a screenshot. File format is 32bit bmp.")]
        public TakeScreenshotCommand TakeScreenshotCommand { get; set; }

        [CommandLineSubCommand("create-target-program-dump", Description = "Create a nxdmp file of running program.")]
        public CreateTargetProgramDumpCommand CreateTargetProgramDumpCommand { get; set; }
    }
}
