﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using Nintendo.ControlTarget.ConsoleShell;

namespace Nintendo.ControlTarget
{
    public class BootSafeModeCommand : CommonTargetCommand
    {
        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Try to connect: {info.GetSerialNumber()}");

                    tmapiAccessor.ConnectTarget(info.GetTargetHandle());

                    var endPoint = tmapiAccessor.FindService("iywys@$csForRunnerTools", info.GetTargetHandle());

                    Trace.WriteLine($"Try to connect: {endPoint.ToString()}");

                    var csAccessor = new ConsoleShellAccessor(new ConsoleShellMessenger(endPoint));

                    Trace.WriteLine($"Try to boot the safemode. serial={info.GetSerialNumber()}");

                    csAccessor.BootSafeMode();
                });
        }
    }
}
