﻿using System.IO;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class BatchDevMenuCommand : CommonDevMenuCommandCommand
    {
        [CommandLineValue(0, ValueName = "DevMenuCommand batch path", Description = "Specifies batch path.")]
        public string BatchPath { get; set; }

        public override void Run()
        {
            RunDevMenuCommandCommand(() => {
                RunDevMenuCommand(
                    "batch",
                    Path.GetFullPath(BatchPath));
            });
        }
    }
}
