﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace HalfAwakeLogMonitor
{
    class CommandLineOption
    {
        [CommandLineOption(
            "hostname",
            IsRequired = true,
            Description = "接続先ターゲットホスト名")]
        public string Target { get; private set; }

        [CommandLineOption(
            "pattern-success-exit",
            Description = "成功と見なす文字列 (正規表現)")]
        public string PatternSuccessExit { get; private set; }

        [CommandLineOption(
            "pattern-failure-exit",
            Description = "失敗と見なす文字列 (正規表現)")]
        public string PatternFailureExit { get; private set; }

        [CommandLineOption(
            "success-timeout",
            Description = "失敗と見なす文字列が現れない場合、成功と見なすまでの時間 (秒)")]
        public int SuccessTimeout { get; private set; }

        [CommandLineOption(
            "failure-timeout",
            Description = "成功と見なす文字列が現れない場合、失敗と見なすまでの時間 (秒)")]
        public int FailureTimeout { get; private set; }

        public static CommandLineOption Parse(string[] args)
        {
            var parser = new CommandLineParser();

            CommandLineOption option;
            var continues = parser.ParseArgs(args, out option);

            if (continues)
            {
                return option;
            }
            else
            {
                return null;
            }
        }
    }
}
