﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class SvcDriverHeaderGenerator : SourceGenerator
    {
        public SvcDriverHeaderGenerator(CodeGenNames p) : base(p) { }

        public void Generate(
            SvcSet ss,
            Dictionary<string, AbiLayout> abi,
            string templatePath,
            string path)
        {
            this.Generate(ss, abi, null, null, templatePath, path);
        }

        protected override string Generate(
            SvcSet ss,
            Dictionary<string, AbiLayout> abi,
            Dictionary<string, SvcLayout> svc,
            Dictionary<string, LayoutConversion> conv)
        {
            var sb = new StringBuilder();
            sb.Append(SourceGenerator.MakePragmaOnce());
            sb.AppendLine();
            sb.Append(SourceGenerator.MakeNameSpaceBeginText(CodeGenNames.KernelCommonNamespace));
            sb.AppendLine();
            sb.AppendFormat("    class {0}\r\n", Params.DriverClassName);
            sb.AppendLine  ("    {");
            sb.AppendLine  ("    public:");

            foreach (var op in ss.Operations)
            {
                sb.AppendFormat("        static void Call{0}();\r\n", op.Name);
            }

            sb.AppendLine("    };");
            sb.AppendLine();
            sb.Append(SourceGenerator.MakeNameSpaceEndText(CodeGenNames.KernelCommonNamespace));
            sb.AppendLine();
            return sb.ToString();
        }
    }
}
