﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class SvcIdGenerator : SourceGenerator
    {
        public void Generate(SvcSet ss, string templatePath, string pathTemplate)
        {
            this.GenerateWithCategory(ss, null, null, null, templatePath, pathTemplate);
        }

        protected override string Generate(CategorySet c,
            Dictionary<string, AbiLayout> abi,
            Dictionary<string, SvcLayout> svc,
            Dictionary<string, LayoutConversion> conv)
        {
            if (c.Operations == null)
            {
                return null;
            }

            var maxLength = c.Operations.Select(x => MakeMacroName(x.Name).Length).Max();
            var lineFormat = string.Concat("#define ", CodeGenNames.IdNamePrefix, "{0,-", maxLength, "} {1,5}\r\n");

            var sb = new StringBuilder();
            sb.Append(SourceGenerator.MakePragmaOnce());
            sb.AppendLine();

            foreach (var op in c.Operations)
            {
                sb.AppendFormat(lineFormat, SourceGenerator.MakeMacroName(op.Name), op.FunctionNumber);
            }

            sb.AppendLine();
            return sb.ToString();
        }
    }
}
