﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class OperationParameter
    {
        public enum DirectionType
        {
            In,
            Out,
            InPtr,
            OutPtr,
        }

        public bool IsArray { get; private set; }
        public string Name { get; private set; }
        public Type Type { get; private set; }
        public DirectionType Direction { get; private set; }

        private int m_Size;
        private int m_Alignment;

        public bool IsInput
        {
            get
            {
                return (Direction == DirectionType.In)
                    || (Direction == DirectionType.InPtr);
            }
        }
        public bool IsPointerForced
        {
            get
            {
                return (Direction == DirectionType.InPtr)
                    || (Direction == DirectionType.OutPtr);
            }
        }
        public bool IsUnknownSize
        {
            get { return m_Size == Type.UnknownSizeValue; }
        }
        public bool IsPointerSize
        {
            get { return m_Size == Type.PointerSizeValue; }
        }
        public bool IsRegisterSize
        {
            get { return m_Size == Type.RegisterSizeValue; }
        }
        public int GetSize(int pointerSize, int registerSize)
        {
            return IsPointerSize ? pointerSize : (IsRegisterSize ? registerSize : m_Size);
        }
        public string GetSizeText(int pointerSize, int registerSize)
        {
            return IsPointerSize ? pointerSize.ToString() : (IsRegisterSize ? registerSize.ToString() : SizeText);
        }

        private string SizeText
        {
            get
            {
                return IsUnknownSize ? "--" : m_Size.ToString();
            }
        }

        public OperationParameter(string n, Type t, DirectionType d, int s, int a, bool ia)
        {
            Name = n;
            Type = t;
            Direction = d;
            m_Size = s;
            m_Alignment = a;
            IsArray = ia;
        }
    }
}
