﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class LayoutConversionOperationPack : LayoutConversion.Operation
    {
        // ABI: レジスタ x 1
        // SVC: レジスタ x 2

        public LayoutConversionOperationPack(
            int abiIndex, int svcIndex0, int svcIndex1, int storageSize, string name)
            : base("Pack", abiIndex, new int[] { svcIndex0, svcIndex1 }, storageSize, 0, name)
        {
        }

        public override void GenerateCodeInAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, int stackOffset)
        {
            this.ThrowUnexpectedOperation();
        }
        public override bool CanGenerateCodeInSvcToAbi(RegisterUsageTracer tracer)
        {
            tracer.Release(this.SvcIndex[0]);
            tracer.Release(this.SvcIndex[1]);
            return tracer.TryOccupy(this.AbiIndex, "abi " + this.VariableName);
        }
        public override void GenerateCodeInSvcToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            tracer.Release(this.SvcIndex[0]);
            tracer.Release(this.SvcIndex[1]);
            tracer.Occupy(this.AbiIndex, "abi " + this.VariableName);

            cg.Pack64Bit(this.AbiIndex, this.SvcIndex[1], this.SvcIndex[0], this.VariableName);
        }
        public override void GenerateCodeOutPrepareToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            // nothing to do
        }
        public override void GenerateCodeOutAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            cg.Unpack64Bit(this.SvcIndex[1], this.SvcIndex[0], this.AbiIndex, this.VariableName);
        }
        public override void GenerateCodeOutSvcToAbi(
            CodeGenerator cg,
            RegisterUsageTracer tracer,
            Dictionary<int, int> saveMap,
            int safeRegister,
            int stackOffset)
        {
            this.ThrowUnexpectedOperation();
        }
    }
}
