﻿using System;
using System.Collections.Generic;

namespace MetaModel
{
    [System.Xml.Serialization.XmlRoot("Core")]
    public class MetaModel
    {
        // オプションで指定されるデータ
        [System.Xml.Serialization.XmlIgnore]
        public string MetaFileName { get; set; }

        // オプションで指定されるデータ
        [System.Xml.Serialization.XmlIgnore]
        public string KernelVersion { get; set; }

        // オプションで指定されるデータ
        [System.Xml.Serialization.XmlIgnore]
        public bool NoCheckProgramId { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ProgramIdValue { get; set; }
        private string _ProgramId;
        [System.Xml.Serialization.XmlElement("ProgramId", IsNullable=false)]
        public string ProgramId
        {
            get { return _ProgramId; }
            set
            {
                if (_ProgramId != null)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidOverlap, "Core/ProgramId", "Core/ApplicationId"));
                }
                ProgramIdValue = DescModel.ConvertUtils.ConvertHexString(value, "Core/ProgramId");
                _ProgramId = value;
            }
        }

        [System.Xml.Serialization.XmlElement("ApplicationId", IsNullable=false)]
        public string ApplicationId
        {
            get { return _ProgramId; }
            set
            {
                if (_ProgramId != null)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidOverlap, "Core/ProgramId", "Core/ApplicationId"));
                }
                ProgramIdValue = DescModel.ConvertUtils.ConvertHexString(value, "Core/ApplicationId");
                _ProgramId = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public bool Is64BitInstructionValue { get; set; }
        private string _Is64BitInstruction;
        [System.Xml.Serialization.XmlElement("Is64BitInstruction")]
        public string Is64BitInstruction
        {
            get { return _Is64BitInstruction; }
            set
            {
                Is64BitInstructionValue = DescModel.ConvertUtils.ConvertBoolString(value, "Core/Is64BitInstruction");
                _Is64BitInstruction = Convert.ToBoolean(Is64BitInstructionValue).ToString();
            }
        }

        public const string AddressSpace32Bit = "AddressSpace32Bit";
        public const string AddressSpace64Bit = "AddressSpace64Bit";
        public const string AddressSpace64BitOld = "AddressSpace64BitOld";
        public const string AddressSpace32BitNoReserved = "AddressSpace32BitNoReserved";
        private string _ProcessAddressSpace;
        [System.Xml.Serialization.XmlElement("ProcessAddressSpace")]
        public string ProcessAddressSpace
        {
            get { return _ProcessAddressSpace; }
            set
            {
                switch (value)
                {
                    case AddressSpace32Bit:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64BitOld:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace32BitNoReserved:
                        _ProcessAddressSpace = value;
                        break;
                    case AddressSpace64Bit:
                        _ProcessAddressSpace = value;
                        break;
                    default:
                        throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidString, "ProcessAddressSpace", value));
                }
            }
        }

        public const byte LowestThreadPriority = 63;
        public const byte HighestThreadPriority = 0;
        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadPriorityValue { get; set; }
        private string _MainThreadPriority;
        [System.Xml.Serialization.XmlElement("MainThreadPriority")]
        public string MainThreadPriority
        {
            get { return _MainThreadPriority; }
            set
            {
                MainThreadPriorityValue = checked((byte)DescModel.ConvertUtils.ConvertDecimalString(value, "Core/MainThreadPriority"));
                if (MainThreadPriorityValue < HighestThreadPriority || MainThreadPriorityValue > LowestThreadPriority)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_OutOfRange, "Core/MainThreadPriority", value));
                }
                _MainThreadPriority = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MainThreadCoreNumberValue { get; set; }
        private string _MainThreadCoreNumber;
        [System.Xml.Serialization.XmlElement("MainThreadCoreNumber")]
        public string MainThreadCoreNumber
        {
            get { return _MainThreadCoreNumber; }
            set
            {
                MainThreadCoreNumberValue = checked((byte)DescModel.ConvertUtils.ConvertDecimalString(value, "Core/MainThreadCoreNumber"));
                _MainThreadCoreNumber = value;
            }
        }

        public const uint AlignMainThraedStackSize = 0x1000;
        [System.Xml.Serialization.XmlIgnore]
        public uint MainThreadStackSizeValue { get; set; }
        private string _MainThreadStackSize;
        [System.Xml.Serialization.XmlElement("MainThreadStackSize")]
        public string MainThreadStackSize
        {
            get { return _MainThreadStackSize; }
            set
            {
                MainThreadStackSizeValue = checked((UInt32)DescModel.ConvertUtils.ConvertHexString(value, "Core/MainThreadStackSize"));
                if ((MainThreadStackSizeValue & (AlignMainThraedStackSize - 1)) > 0)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidAlign, "Core/MainThreadStackSize", AlignMainThraedStackSize));
                }
                if (MainThreadStackSizeValue == 0)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_Invalid0, "Core/MainThreadStackSize"));
                }
                _MainThreadStackSize = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public uint VersionValue { get; set; }
        private string _Version;
        [System.Xml.Serialization.XmlElement("Version")]
        public string Version
        {
            get { return _Version; }
            set
            {
                VersionValue = checked((uint)DescModel.ConvertUtils.ConvertDecimalString(value, "Core/Version"));
                _Version = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte[] NameValue { get; set; }
        public const int MaxNameSize = 15;
        private string _Name;
        [System.Xml.Serialization.XmlElement("Name")]
        public string Name
        {
            get { return _Name; }
            set
            {
                NameValue = System.Text.Encoding.UTF8.GetBytes(value);
                if (NameValue.Length > MaxNameSize)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidStringLength, "Core/Name", MaxNameSize));
                }
                _Name = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public const int MaxProductCodeSize = 15;
        private string _ProductCode;
        [System.Xml.Serialization.XmlElement("ProductCode")]
        public string ProductCode
        {
            get { return _ProductCode; }
            set
            {
                if (value.Length > MaxProductCodeSize)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidStringLength, "Core/ProductCode", MaxProductCodeSize));
                }
                _ProductCode = value;
            }
        }

        public const uint AlignSystemResourceSize = 0x200000;
        public const uint MaxSystemResourceSize = 510 * 1024 * 1024; // 本当は 512MB - 128KB だが設定は 2MB 単位なので最大 510MB
        [System.Xml.Serialization.XmlIgnore]
        public uint SystemResourceSizeValue { get; set; }
        private string _SystemResourceSize;
        [System.Xml.Serialization.XmlElement("SystemResourceSize")]
        public string SystemResourceSize
        {
            get { return _SystemResourceSize; }
            set
            {
                SystemResourceSizeValue = checked((uint)DescModel.ConvertUtils.ConvertHexString(value, "Core/SystemResourceSize"));
                if ((SystemResourceSizeValue & (AlignSystemResourceSize - 1)) > 0)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_InvalidAlign, "Core/SystemResourceSize", AlignSystemResourceSize));
                }
                if (SystemResourceSizeValue > MaxSystemResourceSize)
                {
                    throw new ArgumentException(string.Format(MakeMeta.Properties.Resources.Message_OutOfRange, "Core/SystemResourceSize", SystemResourceSizeValue));
                }
                _SystemResourceSize = value;
            }
        }

        [System.Xml.Serialization.XmlElement("FsAccessControlData")]
        public DescModel.FaDataModel  FsAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("SrvAccessControlData")]
        public DescModel.SaDataModel SrvAccessControlData { get; set; }

        [System.Xml.Serialization.XmlElement("KernelCapabilityData")]
        public DescModel.KcDataModel KernelCapabilityData { get; set; }
    }
}
