﻿using System;
using System.Xml;
using System.Collections.Generic;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("ThreadInfo")]
    public class KcThreadInfoModel
    {
        [System.Xml.Serialization.XmlIgnore]
        public byte LowestPriorityValue { get; set; }
        private string _LowestPriority;
        [System.Xml.Serialization.XmlElement("LowestPriority", IsNullable=false)]
        public string LowestPriority
        {
            get { return _LowestPriority; }
            set
            {
                if (value == null)
                {
                    return;
                }
                LowestPriorityValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "ThreadInfo/LowestPriority"));
                _LowestPriority = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte HighestPriorityValue { get; set; }
        private string _HighestPriority;
        [System.Xml.Serialization.XmlElement("HighestPriority", IsNullable=false)]
        public string HighestPriority
        {
            get { return _HighestPriority; }
            set
            {
                if (value == null)
                {
                    return;
                }
                HighestPriorityValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "ThreadInfo/HighestPriority"));
                _HighestPriority = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MinCoreNumberValue { get; set; }
        private string _MinCoreNumber;
        [System.Xml.Serialization.XmlElement("MinCoreNumber", IsNullable=false)]
        public string MinCoreNumber
        {
            get { return _MinCoreNumber; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MinCoreNumberValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "ThreadInfo/MinCoreNumber"));
                _MinCoreNumber = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MaxCoreNumberValue { get; set; }
        private string _MaxCoreNumber;
        [System.Xml.Serialization.XmlElement("MaxCoreNumber", IsNullable=false)]
        public string MaxCoreNumber
        {
            get { return _MaxCoreNumber; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MaxCoreNumberValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "ThreadInfo/MaxCoreNumber"));
                _MaxCoreNumber = value;
            }
        }

        public bool CheckSuccessToRead()
        {
            if (LowestPriority != null && HighestPriority != null && MinCoreNumber != null && MaxCoreNumber != null)
            {
                return true;
            }
            if (LowestPriority == null && HighestPriority == null && MinCoreNumber == null && MaxCoreNumber == null)
            {
                return false;
            }

            // 以下は例外にする
            if (LowestPriority == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "ThreadInfo/LowestPriority"));
            }
            if (HighestPriority == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "ThreadInfo/HighestPriority"));
            }
            if (MinCoreNumber == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "ThreadInfo/MinCoreNumber"));
            }
            if (MaxCoreNumber == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "ThreadInfo/MaxCoreNumber"));
            }

            throw new InvalidOperationException ();
        }
    }

    [System.Xml.Serialization.XmlRoot("EnableSystemCalls")]
    public class KcEnableSystemCallsModel
    {
        [System.Xml.Serialization.XmlElement("Name", IsNullable=false)]
        public string Name { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public byte SystemCallIdValue{ get; set; }
        private string _SystemCallId;
        [System.Xml.Serialization.XmlElement("SystemCallId", IsNullable=false)]
        public string SystemCallId
        {
            get { return _SystemCallId; }
            set
            {
                if (value == null)
                {
                    return;
                }
                SystemCallIdValue = checked((byte)ConvertUtils.ConvertDecimalString(value, "EnableSystemCalls/SystemCallId"));
                _SystemCallId = value;
            }
        }

        public bool CheckSuccessToRead()
        {
            if (Name != null && SystemCallId != null)
            {
                return true;
            }

            if (Name == null && SystemCallId == null)
            {
                return false;
            }

            // 以下は例外にする
            if (Name == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "EnableSystemCalls/Name"));
            }
            if (SystemCallId == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "EnableSystemCalls/SystemCallId"));
            }

            throw new InvalidOperationException ();
        }
    }

    [System.Xml.Serialization.XmlRoot("MemoryMap")]
    public class KcMemoryMapModel
    {
        [System.Xml.Serialization.XmlIgnore]
        public UInt64 BeginAddressValue { get; set; }
        private string _BeginAddress;
        [System.Xml.Serialization.XmlElement("BeginAddress", IsNullable=false)]
        public string BeginAddress
        {
            get { return _BeginAddress; }
            set
            {
                if (value == null)
                {
                    return;
                }
                BeginAddressValue = ConvertUtils.ConvertHexString(value, "MemoryMap/BeginAddress");
                _BeginAddress = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public uint SizeValue { get; set; }
        private string _Size;
        [System.Xml.Serialization.XmlElement("Size", IsNullable=false)]
        public string Size
        {
            get { return _Size; }
            set
            {
                if (value == null)
                {
                    return;
                }
                SizeValue = checked((uint)ConvertUtils.ConvertHexString(value, "MemoryMap/Size"));
                _Size = value;
            }
        }

        public const string Permission_Ro = "RO";
        public const string Permission_Rw = "RW";

        private string _Permission;
        [System.Xml.Serialization.XmlElement("Permission", IsNullable=false)]
        public string Permission
        {
            get { return _Permission; }
            set
            {
                if (value == null)
                {
                    return;
                }

                if (value.ToUpper() == Permission_Ro)
                {
                    _Permission = value;
                }
                else if (value.ToUpper() == Permission_Rw)
                {
                    _Permission = value;
                }
                else
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidArgumentString_2, "MemoryMap/Permission", Permission_Ro.ToUpper(), Permission_Rw.ToUpper()));
                }
            }
        }

        public const string Type_Io = "Io";
        public const string Type_Static = "Static";

        private string _Type;
        [System.Xml.Serialization.XmlElement("Type", IsNullable=false)]
        public string Type
        {
            get { return _Type; }
            set
            {
                if (value == null)
                {
                    return;
                }

                switch (value)
                {
                    case Type_Io:
                        _Type = value;
                        break;
                    case Type_Static:
                        _Type = value;
                        break;
                    default:
                        throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidArgumentString_2, "MemoryMap/Type", Type_Io, Type_Static));
                }
            }
        }

        public bool CheckSuccessToRead()
        {
            if (BeginAddress != null && Size != null && Permission != null && Type != null)
            {
                return true;
            }
            if (BeginAddress == null && Size == null && Permission == null && Type == null)
            {
                return false;
            }

            // 以下は例外にする
            if (BeginAddress == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "MemoryMap/BeginAddress"));
            }
            if (Size == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "MemoryMap/Size"));
            }
            if (Permission == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "MemoryMap/Permission"));
            }
            if (Type == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "MemoryMap/Type"));
            }

            throw new InvalidOperationException();
        }
    }

    [System.Xml.Serialization.XmlRoot("MiscParams")]
    public class KcMiscParamsModel
    {
        public const byte ProgramType_System = 0;
        public const byte ProgramType_Application = 1;
        public const byte ProgramType_Applet = 2;

        [System.Xml.Serialization.XmlIgnore]
        public byte ProgramTypeValue { get; set; }
        private string _ProgramType;
        [System.Xml.Serialization.XmlElement("ProgramType", IsNullable=false)]
        public string ProgramType
        {
            get { return _ProgramType; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ProgramTypeValue = (byte)ConvertUtils.ConvertDecimalString(value, "MiscParams/ProgramType");
                _ProgramType = value;
            }
        }

        public bool CheckSuccessToRead()
        {
            return ProgramType != null;
        }
    }

    [System.Xml.Serialization.XmlRoot("KernelVersion")]
    public class KcKernelVersionModel
    {
        [System.Xml.Serialization.XmlIgnore]
        public ushort MajorVersionVlaue { get; set; }
        private string _MajorVersion;
        [System.Xml.Serialization.XmlElement("MajorVersion", IsNullable=false)]
        public string MajorVersion
        {
            get { return _MajorVersion; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MajorVersionVlaue = checked((ushort)ConvertUtils.ConvertDecimalString(value, "KernelVersion/MajorVersion"));
                _MajorVersion = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public byte MinorVersionVlaue { get; set; }
        private string _MinorVersion;
        [System.Xml.Serialization.XmlElement("MinorVersion", IsNullable=false)]
        public string MinorVersion
        {
            get { return _MinorVersion; }
            set
            {
                if (value == null)
                {
                    return;
                }
                MinorVersionVlaue = checked((byte)ConvertUtils.ConvertDecimalString(value, "KernelVersion/MinorVersion"));
                _MinorVersion = value;
            }
        }
    }

    [System.Xml.Serialization.XmlRoot("MiscFlags")]
    public class KcMiscFlags
    {
        [System.Xml.Serialization.XmlIgnore]
        public bool EnableDebugValue { get; set; }
        private string _EnableDebug;
        [System.Xml.Serialization.XmlElement("EnableDebug")]
        public string EnableDebug
        {
            get { return _EnableDebug; }
            set
            {
                if (value == null)
                {
                    return;
                }

                EnableDebugValue = ConvertUtils.ConvertBoolString(value, "MiscFlags/EnableDebug");
                _EnableDebug = EnableDebugValue.ToString();
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public bool ForceDebugValue { get; set; }
        private string _ForceDebug;
        [System.Xml.Serialization.XmlElement("ForceDebug")]
        public string ForceDebug
        {
            get { return _ForceDebug; }
            set
            {
                if (value == null)
                {
                    return;
                }

                ForceDebugValue = ConvertUtils.ConvertBoolString(value, "MiscFlags/ForceDebug");
                _ForceDebug = ForceDebugValue.ToString();
            }
        }

        public bool CheckSuccessToRead()
        {
            if (EnableDebug != null || ForceDebug != null)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
