﻿using System;
namespace DescModel
{
    public class ConvertUtils
    {
        public static UInt64 ConvertDecimalString(string value, string tagName)
        {
            try
            {
                return UInt64.Parse(value);
            }
            catch
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidDecimalNumberString, tagName));
            }
        }

        public static UInt64 ConvertHexString(string value, string tagName)
        {
            if (value.IndexOf("0x") != 0)
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidHexadecimalNumberString, tagName));
            }

            string tmp = value.Replace("0x", "");

            try
            {
                return UInt64.Parse(tmp, System.Globalization.NumberStyles.HexNumber);
            }
            catch
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidHexadecimalNumberString, tagName));
            }
        }

        public static String ConvertToHexString(UInt64 value)
        {
            return string.Format("0x{0:X}", value);
        }

        public static bool ConvertBoolString(string value, string tagName)
        {
            try
            {
                return bool.Parse(value);
            }
            catch
            {
                throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidBoolString, tagName));
            }
        }
    }
}
