﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.ObjectModel;

namespace MakeFirmwareArchive
{
    public class FirmwareArchivePartition
    {
        //!< 正しいパーティションの名前のリスト
        public static readonly ReadOnlyCollection<string> ValidPartitionNames =
            Array.AsReadOnly(new string[]
            {
                // Special Partition
                "BootPartition1-Bct-1st",
                "BootPartition1-Bct-2nd",
                "BootPartition1-Bct-Normal",
                "BootPartition1-Bct-SafeMode",
                "BootPartition1-Bct-Repair",
                "BootPartition1-Normal-Package1-Main",
                "BootPartition1-Normal-Package1-Sub",
                "BootPartition2-SafeMode-Package1-Main",
                "BootPartition2-SafeMode-Package1-Sub",
                "BootPartition2-Repair-Package1-Main",
                "BootPartition2-Repair-Package1-Sub",

                // Partition
                //"PRODINFO", // 名前としては正しいが、書き込まない領域のためコメントアウト
                "PRODINFOF",

                "BootConfig1",
                "BootConfig2",
                "BootConfig3",
                "BootConfig4",
                "BootConfig5",
                "BootConfig6",

                "BCPKG2-1-Normal-Main",
                "BCPKG2-2-Normal-Sub",
                "BCPKG2-3-SafeMode-Main",
                "BCPKG2-4-SafeMode-Sub",
                "BCPKG2-5-Repair-Main",
                "BCPKG2-6-Repair-Sub",
                "SAFE",
                "USER",
                "SYSTEM",

                //初期化イメージ設定ファイル置場
                "config",

                //Recovery ツール置場
                "Recovery"
            }
        );

        //!< 正しいパーティションの名前かを返します
        public static bool IsValidPartitionName(string name)
        {
            return ValidPartitionNames.Contains(name);
        }

        public static void PrintValidPartitionName()
        {
            foreach (var partitionName in ValidPartitionNames)
            {
                Console.WriteLine(partitionName);
            }
        }
    }
}
