﻿using System;
using System.Collections.Generic;

namespace Nintendo.Log
{
    public class LogFilterParserTest
    {
        private static LogFilterParser Parser = new LogFilterParser();

        private static void PrintResult(string text, bool expectedResult, bool IsSuccess, string reason)
        {
            var currentColor = Console.ForegroundColor;
            if (IsSuccess)
            {
                Console.ForegroundColor = ConsoleColor.Green;
                Console.Write("[ OK ] ");
            }
            else
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.Write("[ NG ] ");
            }
            Console.ForegroundColor = currentColor;
            Console.WriteLine("{0,-30} is {1,-5} {2,-20}", text, expectedResult, reason);
        }

        private static void RunTest(string text, bool expectedResult, string expectedExceptionMessage)
        {
            var isSuccess = false;
            var reason = string.Empty;
            try
            {
                var parseNode = Parser.Evaluate(text);
                var result = parseNode.Evaluate(new Dictionary<string, object>());
                if (result is bool)
                {
                    isSuccess = (((bool)result) == expectedResult);
                }
                else
                {
                    isSuccess = false;
                    reason = "評価結果が bool になりませんでした。";
                }
            }
            catch (Exception exception)
            {
                if (string.IsNullOrEmpty(expectedExceptionMessage))
                {
                    isSuccess = false;
                    reason = "Unexpected exception: " + exception.Message;
                }
                else if (expectedExceptionMessage != exception.Message)
                {
                    isSuccess = false;
                    reason = "Unexpected exception message: " + exception.Message;
                }
                else
                {
                    isSuccess = true;
                }
            }
            finally
            {
                PrintResult(text, expectedResult, isSuccess, reason);
            }
        }

        public static void TestMain()
        {
            RunTest("1 <= 1", true, null);
            RunTest("1 >= 1", true, null);
            RunTest("1 < 1", false, null);
            RunTest("1 > 1", false, null);
            RunTest("1 == 1", true, null);
            RunTest("1 != 1", false, null);
            RunTest("2 <= 3", true, null);
            RunTest("2 >= 3", false, null);
            RunTest("2 < 3", true, null);
            RunTest("2 > 3", false, null);
            RunTest("2 == 3", false, null);
            RunTest("2 != 3", true, null);
            RunTest("3 <= 2", false, null);
            RunTest("3 >= 2", true, null);
            RunTest("3 < 2", false, null);
            RunTest("3 > 2", true, null);
            RunTest("3 == 2", false, null);
            RunTest("3 != 2", true, null);
            RunTest("1 == 1 && 2 == 2", true, null);
            RunTest("1 != 1 && 2 == 2", false, null);
            RunTest("1 == 1 && 2 != 2", false, null);
            RunTest("1 != 1 && 2 != 2", false, null);
            RunTest("(1 == 1) && 2 == 2", true, null);
            RunTest("(1 != 1) && 2 == 2", false, null);
            RunTest("(1 == 1) && 2 != 2", false, null);
            RunTest("(1 != 1) && 2 != 2", false, null);
            RunTest("1 == 1 && (2 == 2)", true, null);
            RunTest("1 != 1 && (2 == 2)", false, null);
            RunTest("1 == 1 && (2 != 2)", false, null);
            RunTest("1 != 1 && (2 != 2)", false, null);
            RunTest("1 == 1 || 2 == 2", true, null);
            RunTest("1 != 1 || 2 == 2", true, null);
            RunTest("1 == 1 || 2 != 2", true, null);
            RunTest("1 != 1 || 2 != 2", false, null);
            RunTest("(1 == 1) || 2 == 2", true, null);
            RunTest("(1 != 1) || 2 == 2", true, null);
            RunTest("(1 == 1) || 2 != 2", true, null);
            RunTest("(1 != 1) || 2 != 2", false, null);
            RunTest("1 == 1 || (2 == 2)", true, null);
            RunTest("1 != 1 || (2 == 2)", true, null);
            RunTest("1 == 1 || (2 != 2)", true, null);
            RunTest("1 != 1 || (2 != 2)", false, null);
            RunTest("(1 == 1) || (2 == 2)", true, null);
            RunTest("(1 != 1) || (2 == 2)", true, null);
            RunTest("(1 == 1) || (2 != 2)", true, null);
            RunTest("(1 != 1) || (2 != 2)", false, null);
            RunTest("1 == 1 && 2 == 2 || 3 == 3", true, null);
            RunTest("1 != 1 && 2 == 2 || 3 == 3", true, null);
            RunTest("1 == 1 && 2 != 2 || 3 == 3", true, null);
            RunTest("1 != 1 && 2 != 2 || 3 == 3", true, null);
            Console.WriteLine("Press any to exit...");
            Console.ReadKey();
        }
    }
}
