﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace HtcDaemon
{
    public struct TargetId : IEquatable<TargetId>, IComparable<TargetId>, IComparable
    {
        public static readonly TargetId TargetIdHost = new TargetId(0);

        public TargetId(ulong idValue)
            : this()
        {
            this.Value = idValue;
        }

        public ulong Value { get; private set; }    // TODO: 実際には文字列

        public override bool Equals(object obj)
        {
            return this.Value.Equals(obj);
        }

        public override int GetHashCode()
        {
            return this.Value.GetHashCode();
        }

        public override string ToString()
        {
            return this.Value.ToString();
        }

        public bool Equals(TargetId other)
        {
            return this.Value.Equals(other.Value);
        }

        public int CompareTo(TargetId other)
        {
            return this.Value.CompareTo(other.Value);
        }

        public int CompareTo(object obj)
        {
            return this.Value.CompareTo(obj);
        }

        public const string XElementName = "TargetId";

        public TargetId(XElement xElement)
            : this()
        {
            this.Value = ulong.Parse(xElement.Value);
        }

        public XElement ToXElement()
        {
            return new XElement(XElementName, Value);
        }
    }
}
