﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.Htcs
{
    public class HtcsInfo
    {
        public const string XElementName = "HtcsInfo";
        public TargetList TargetList { get; private set; }
        public PortMap PortMap { get; private set; }

        public HtcsInfo()
        {
            this.TargetList = new TargetList();
            this.PortMap = new PortMap();
        }

        internal HtcsInfo(XElement xElement)
        {
            this.TargetList = new TargetList(xElement.Element(TargetList.XElementName));
            this.PortMap = new PortMap(xElement.Element(PortMap.XElementName));
        }

        internal XElement ToXElement()
        {
            return new XElement(XElementName,
                this.TargetList.ToXElement(),
                this.PortMap.ToXElement());
        }
    }
}
