﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon.Usb
{
    [Serializable]
    public class DeviceNotFunctioningException : OperationCanceledException
    {
        public DeviceNotFunctioningException() { }
        public DeviceNotFunctioningException(string message) : base(message) { }
        public DeviceNotFunctioningException(string message, Exception inner) : base(message, inner) { }
        protected DeviceNotFunctioningException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class DeviceNotFoundException : Exception
    {
        public DeviceNotFoundException() { }
        public DeviceNotFoundException(string message) : base(message) { }
        public DeviceNotFoundException(string message, Exception inner) : base(message, inner) { }
        protected DeviceNotFoundException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class UsbDeviceException : Exception
    {
        public UsbDeviceException() { }
        public UsbDeviceException(string message) : base(message) { }
        public UsbDeviceException(string message, Exception inner) : base(message, inner) { }
        protected UsbDeviceException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }

    [Serializable]
    public class InvalidDeviceException : UsbDeviceException
    {
        public InvalidDeviceException() { }
        public InvalidDeviceException(string message) : base(message) { }
        public InvalidDeviceException(string message, Exception inner) : base(message, inner) { }
        protected InvalidDeviceException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }
}
