﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon
{
    internal class StringUtil
    {
        public static string StringFromCStyleString(byte[] data)
        {
            var sb = new StringBuilder();
            foreach (var b in data)
            {
                if (b == 0)
                {
                    break;
                }

                sb.Append((char)b);
            }
            return sb.ToString();
        }

        public static byte[] StringToCStyleString(string s, int count)
        {
            byte[] data = new byte[count];

            if (s.Length > count - 1)
            {
                throw new ArgumentException("string longer than the length of the specified buffer.", "s");
            }

            int copyCount = Math.Min(s.Length, count - 1);
            for (int i = 0; i < copyCount; i++)
            {
                data[i] = (byte)s[i];
            }

            return data;
        }
    }
}
