﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Htcs;

namespace HtcDaemon
{
    internal class HostPortRegisteredEventArgs : EventArgs
    {
        public PortMapItem PortMapItem { get; private set; }
        public string RequestName { get; private set; }

        public HostPortRegisteredEventArgs(PortMapItem portMapItem, string requestName)
        {
            this.PortMapItem = portMapItem;
            this.RequestName = requestName;
        }
    }

    internal class TargetPortRegisteredEventArgs : EventArgs
    {
        public Target Target { get; private set; }
        public PortMapItem PortMapItem { get; private set; }

        public TargetPortRegisteredEventArgs(PortMapItem portMapItem)
        {
            this.Target = new Target("HTCS", portMapItem.HtcsPortDescriptor.HtcsPeerName.Value); // PeerType is tentative
            this.PortMapItem = portMapItem;
        }
    }

    internal class HostPortUnregisteredEventArgs : EventArgs
    {
        public HtcsPortDescriptor HtcsPortDescriptor { get; private set; }
        public string RequestName { get; private set; }

        public HostPortUnregisteredEventArgs(HtcsPortDescriptor htcsPortDescriptor, string requestName)
        {
            this.HtcsPortDescriptor = htcsPortDescriptor;
            this.RequestName = requestName;
        }
    }

    internal class TargetPortUnregisteredEventArgs : EventArgs
    {
        public HtcsPortDescriptor HtcsPortDescriptor { get; private set; }

        public TargetPortUnregisteredEventArgs(HtcsPortDescriptor htcsPortDescriptor)
        {
            this.HtcsPortDescriptor = htcsPortDescriptor;
        }
    }

    internal class TargetEventArgs : EventArgs
    {
        public TargetEventArgs(HtcsPeerName targetPeerName)
        {
            this.TargetPeerName = targetPeerName;
        }

        public HtcsPeerName TargetPeerName { get; private set; }
    }

    internal class TcpConnectedEventArgs : EventArgs
    {
        public Socket Socket { get; private set; }

        public TcpConnectedEventArgs(Socket socket)
        {
            this.Socket = socket;
        }
    }

    internal class TargetDetectedEventArgs : EventArgs
    {
        public HostTargetConnection Connection { get; private set; }

        public TargetDetectedEventArgs(HostTargetConnection connection)
        {
            this.Connection = connection;
        }
    }

    internal class ChannelEventArgs : EventArgs
    {
        public IChannel Channel { get; private set; }

        public ChannelEventArgs(IChannel channel)
        {
            this.Channel = channel;
        }
    }

    internal class PortEventArgs : EventArgs
    {
        public string HtcsPortName { get; private set; }

        public PortEventArgs(string htcsPortName)
        {
            this.HtcsPortName = htcsPortName;
        }
    }
}
