﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Nintendo.Htcs;

namespace HtcDaemon.DirectSocket
{
    internal class DirectSocketControlCommunicator : ControlCommunicator
    {
        private IPEndPoint targetEndPoint;

        public DirectSocketControlCommunicator(Mux mux, IPEndPoint targetEndPoint)
            : base(mux)
        {
            this.targetEndPoint = targetEndPoint;
        }

        protected override IHostAppListener CreateHostAppListener(string htcsPortName, int port)
        {
            return new DirectSocketHostAppListener(new IPEndPoint(targetEndPoint.Address, port));
        }
    }
}
