﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsFileCacheSimulator.Simulation.Algorithm
{
    internal class LruList<TKey, TValue>
    {
        private readonly int m_CacheCount;
        private LinkedList<Tuple<TKey, TValue>> m_CacheList;
        private Dictionary<TKey, LinkedListNode<Tuple<TKey, TValue>>> m_CacheTree;

        public LruList(int cacheCount)
        {
            m_CacheCount = cacheCount;
            m_CacheList = new LinkedList<Tuple<TKey, TValue>>();
            m_CacheTree = new Dictionary<TKey, LinkedListNode<Tuple<TKey, TValue>>>();
        }

        public bool ContainsKey(TKey key)
        {
            return Find(key) != null;
        }

        public int CountUsed()
        {
            return m_CacheList.Count;
        }

        public int CountFree()
        {
            return m_CacheCount - m_CacheList.Count;
        }

        public LinkedListNode<Tuple<TKey, TValue>> Find(TKey key)
        {
            var ret = default(LinkedListNode<Tuple<TKey, TValue>>);
            m_CacheTree.TryGetValue(key, out ret);
            return ret;
        }

        public void Add(TKey key, TValue value)
        {
            if (m_CacheList.Count >= m_CacheCount)
            {
                throw new ImplementationErrorException();
            }

            var node = m_CacheList.AddFirst(Tuple.Create(key, value));
            m_CacheTree.Add(key, node);
        }

        public void Promote(LinkedListNode<Tuple<TKey, TValue>> node)
        {
            m_CacheList.Remove(node);
            m_CacheList.AddFirst(node);
        }

        public void Remove()
        {
            var key = m_CacheList.Last.Value.Item1;
            m_CacheList.RemoveLast();
            m_CacheTree.Remove(key);
        }

        public void Remove(TKey key)
        {
            var node = m_CacheTree[key];
            m_CacheList.Remove(node);
            m_CacheTree.Remove(key);
        }

        public void Clear()
        {
            m_CacheList.Clear();
            m_CacheTree.Clear();
        }
    }
}
