﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using YamlDotNet.Serialization;
using YamlDotNet.Serialization.NamingConventions;

namespace MakePartialDesc
{
    public class InputParameter
    {
        public int MemoryMapPageAlignment { get; set; }
        public string TemplateFilePath { get; set; }
    }

    internal static class InputParameterParser
    {
        public static InputParameter LoadFile(string filePath)
        {
            using (var input = File.OpenText(filePath))
            {
                var deserializer = new DeserializerBuilder()
                    .IgnoreUnmatchedProperties()
                    .WithNamingConvention(new PascalCaseNamingConvention())
                    .Build();
                InputParameter result;
                try
                {
                    result = deserializer.Deserialize<InputParameter>(input);
                }
                catch (Exception e)
                {
                    Console.Error.WriteLine("*** YamlDotNet deserializer threw exception (Check input yml format) ***");
                    if (e.Message != null)
                    {
                        Console.WriteLine($"  Message: {e.Message}");
                    }
                    if (e.InnerException != null)
                    {
                        Console.WriteLine($"  InnerException.Message: {e.InnerException.Message}");
                    }
                    throw;
                }
                return result;
            }
        }
    }
}
