﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static partial class Pms
    {
        // Title 登録で利用
        [DataContract]
        public class TitleInfo
        {
            [DataMember(EmitDefaultValue = false, Name = "id", Order = 0)]
            public long id { get; set; }

            [DataMember(Name = "application_id", Order = 1)]
            public string applicationId { get; set; }

            [DataMember(Name = "device_type", Order = 2)]
            public string deviceType { get; set; }

            [DataMember(Name = "product_class_code", Order = 3)]
            public string productClassCode { get; set; }

            [DataMember(Name = "form_code", Order = 4)]
            public string formCode { get; set; }

            [DataMember(Name = "initial_code", Order = 5)]
            public string initialCode { get; set; }

            [DataMember(Name = "platform", Order = 6)]
            public string platform { get; set; }

            [DataContract]
            public class Rating
            {
                [DataMember(Name = "system", Order = 0)]
                public string system { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "id", Order = 1)]
                public long id { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "descriptors", Order = 2)]
                public List<long> descriptors { get; set; }

                [DataMember(Name = "target_countries", Order = 3)]
                public List<string> targetCountries { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "ratings", Order = 7)]
            public List<Rating> ratings { get; set; }

            [DataContract]
            public class Genre
            {
                [DataMember(Name = "codes", Order = 0)]
                public List<string> codes { get; set; }

                [DataContract]
                public class Name : ILanguageItem<Name>
                {
                    [DataMember(Name = "lang", Order = 0)]
                    public string lang { get; set; }

                    [DataMember(Name = "value", Order = 1)]
                    public string value { get; set; }
                }
                [DataMember(Name = "names", Order = 1)]
                public List<Name> names { get; set; }
            }
            [DataMember(Name = "genre", Order = 8)]
            public Genre genre { get; set; }

            [DataContract]
            public class Players
            {
                [DataContract]
                public class NormalPlayers
                {
                    [DataMember(Name = "min", Order = 0)]
                    public long min { get; set; }

                    [DataMember(Name = "max", Order = 1)]
                    public long max { get; set; }
                }
                [DataMember(Name = "normal_players", Order = 0)]
                public NormalPlayers normalPlayers { get; set; }

                [DataContract]
                public class LocalPlayers
                {
                    [DataMember(Name = "min", Order = 0)]
                    public long min { get; set; }

                    [DataMember(Name = "max", Order = 1)]
                    public long max { get; set; }
                }
                [DataMember(Name = "local_players", Order = 1)]
                public LocalPlayers localPlayers { get; set; }

                [DataContract]
                public class InternetPlayers
                {
                    [DataMember(Name = "min", Order = 0)]
                    public long min { get; set; }

                    [DataMember(Name = "max", Order = 1)]
                    public long max { get; set; }
                }
                [DataMember(Name = "internet_players", Order = 2)]
                public InternetPlayers internetPlayers { get; set; }

                [DataContract]
                public class Description : ILanguageItem<Description>
                {
                    [DataMember(Name = "lang", Order = 0)]
                    public string lang { get; set; }

                    [DataMember(Name = "value", Order = 1)]
                    public string value { get; set; }
                }
                [DataMember(EmitDefaultValue = false, Name = "descriptions", Order = 3)]
                public List<Description> descriptions { get; set; }
            }
            [DataMember(Name = "players", Order = 9)]
            public Players players { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "features", Order = 10)]
            public List<string> features { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "controllers", Order = 11)]
            public List<string> controllers { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "support_languages", Order = 12)]
            public List<string> supportLanguages { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "purchase_restriction_countries", Order = 13)]
            public List<string> purchaseRestrictionCountries { get; set; }

            [DataMember(Name = "publisher", Order = 14)]
            public string publisher { get; set; }

            [DataContract]
            public class PackagePublisher
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "publisher", Order = 1)]
                public string publisher { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "package_publishers", Order = 15)]
            public List<PackagePublisher> packagePublishers { get; set; }

            [DataMember(Name = "payment_recipient", Order = 16)]
            public string paymentRecipient { get; set; }

            [DataMember(Name = "roms", Order = 17)]
            public List<string> roms { get; set; }

            [DataMember(Name = "dominant_color_default_flag", Order = 18)]
            public bool dominantColorDefaultFlag { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "dominant_colors", Order = 19)]
            public List<string> dominantColors { get; set; }

            [DataMember(Name = "membership_only_sales_flag", Order = 20)]
            public bool membershipOnlySalesFlag { get; set; }

            [DataContract]
            public class Names
            {
                [DataContract]
                public class FormalName : ILanguageItem<FormalName>
                {
                    [DataMember(Name = "lang", Order = 0)]
                    public string lang { get; set; }

                    [DataMember(Name = "value", Order = 1)]
                    public string value { get; set; }
                }
                [DataMember(Name = "formal_names", Order = 0)]
                public List<FormalName> formalNames { get; set; }
            }
            [DataMember(Name = "names", Order = 21)]
            public Names names { get; set; }

            [DataContract]
            public class Explanation : ILanguageItem<Explanation>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "explanations", Order = 22)]
            public List<Explanation> explanations { get; set; }

            [DataContract]
            public class CatchCopie : ILanguageItem<CatchCopie>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "catch_copies", Order = 23)]
            public List<CatchCopie> catchCopies { get; set; }

            [DataContract]
            public class Copyright : ILanguageItem<Copyright>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "copyrights", Order = 24)]
            public List<Copyright> copyrights { get; set; }

            [DataContract]
            public class Keyword : ILanguageItem<Keyword>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "keywords", Order = 25)]
            public List<Keyword> keywords { get; set; }

            [DataContract]
            public class Disclaimer : ILanguageItem<Disclaimer>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "disclaimers", Order = 26)]
            public List<Disclaimer> disclaimers { get; set; }

            [DataContract]
            public class StrongDisclaimer
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "strong_disclaimers", Order = 27)]
            public List<StrongDisclaimer> strongDisclaimers { get; set; }

            [DataContract]
            public class MiscDescription
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "peripheral", Order = 1)]
                public string peripheral { get; set; }

                [DataMember(Name = "network", Order = 2)]
                public string network { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "misc_descriptions", Order = 28)]
            public List<MiscDescription> miscDescriptions { get; set; }

            [DataContract]
            public class Notice
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "lang", Order = 1)]
                public string lang { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "type", Order = 0)]
                    public string type { get; set; }

                    [DataMember(Name = "text", Order = 1)]
                    public string text { get; set; }

                    [DataMember(Name = "start_date", Order = 2)]
                    public long startDate { get; set; }

                    [DataMember(Name = "end_date", Order = 3)]
                    public long endDate { get; set; }
                }
                [DataMember(Name = "notices", Order = 2)]
                public List<Item> notices { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "notices", Order = 29)]
            public List<Notice> notices { get; set; }

            [DataContract]
            public class OnlineOnsaleDate
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "year", Order = 1)]
                public long year { get; set; }

                [DataMember(Name = "month", Order = 2)]
                public long month { get; set; }

                [DataMember(Name = "day", Order = 3)]
                public long day { get; set; }
            }
            [DataMember(Name = "online_onsale_dates", Order = 30)]
            public List<OnlineOnsaleDate> onlineOnsaleDates { get; set; }

            [DataContract]
            public class OriginalOnsaleDate
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "year", Order = 1)]
                public long year { get; set; }

                [DataMember(Name = "month", Order = 2)]
                public long month { get; set; }

                [DataMember(Name = "day", Order = 3)]
                public long day { get; set; }
            }
            [DataMember(Name = "original_onsale_dates", Order = 31)]
            public List<OriginalOnsaleDate> originalOnsaleDates { get; set; }

            [DataContract]
            public class PackageOnsaleDate
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "year", Order = 1)]
                public long year { get; set; }

                [DataMember(Name = "month", Order = 2)]
                public long month { get; set; }

                [DataMember(Name = "day", Order = 3)]
                public long day { get; set; }
            }
            [DataMember(Name = "package_onsale_dates", Order = 32)]
            public List<PackageOnsaleDate> packageOnsaleDates { get; set; }

            [DataContract]
            public class Demo
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "ids", Order = 1)]
                public List<long> ids { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "demos", Order = 33)]
            public List<Demo> demos { get; set; }

            [DataContract]
            public class Aoc
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataContract]
                public class Id
                {
                    [DataMember(Name = "id", Order = 0)]
                    public long id { get; set; }

                    [DataMember(Name = "bundle_flag", Order = 1)]
                    public bool bundleFlag { get; set; }
                }
                [DataMember(Name = "ids", Order = 1)]
                public List<Id> ids { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "aocs", Order = 34)]
            public List<Aoc> aocs { get; set; }

            [DataContract]
            public class Ticket
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataContract]
                public class Course
                {
                    [DataMember(Name = "id", Order = 0)]
                    public string id { get; set; }

                    [DataMember(Name = "device_type", Order = 1)]
                    public string deviceType { get; set; }
                }
                [DataMember(Name = "courses", Order = 1)]
                public List<Course> courses { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "tickets", Order = 35)]
            public List<Ticket> tickets { get; set; }

            [DataContract]
            public class Consumable
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "ids", Order = 1)]
                public List<string> ids { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "consumables", Order = 36)]
            public List<Consumable> consumables { get; set; }

            [DataContract]
            public class Images
            {
                [DataContract]
                public class HeroBanner
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "lang", Order = 1)]
                    public string lang { get; set; }

                    [DataMember(Name = "url", Order = 2)]
                    public string url { get; set; }
                }
                [DataMember(Name = "hero_banners", Order = 0)]
                public List<HeroBanner> heroBanners { get; set; }

                [DataContract]
                public class Screenshot
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "lang", Order = 1)]
                    public string lang { get; set; }

                    [DataMember(Name = "urls", Order = 2)]
                    public List<string> urls { get; set; }
                }
                [DataMember(Name = "screenshots", Order = 1)]
                public List<Screenshot> screenshots { get; set; }

                [DataContract]
                public class Package
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "lang", Order = 1)]
                    public string lang { get; set; }

                    [DataMember(Name = "url", Order = 2)]
                    public string url { get; set; }
                }
                [DataMember(Name = "packages", Order = 2)]
                public List<Package> packages { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "images", Order = 37)]
            public Images images { get; set; }

            [DataContract]
            public class Movie
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "lang", Order = 1)]
                public string lang { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "display_flag", Order = 0)]
                    public bool displayFlag { get; set; }

                    [DataMember(Name = "type", Order = 1)]
                    public string type { get; set; }

                    [DataMember(Name = "url", Order = 2)]
                    public string url { get; set; }

                    [DataMember(Name = "start_datetime", Order = 3)]
                    public long startDatetime { get; set; }

                    [DataMember(Name = "end_datetime", Order = 4)]
                    public long endDatetime { get; set; }
                }
                [DataMember(Name = "movies", Order = 2)]
                public List<Item> movies { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "movies", Order = 38)]
            public List<Movie> movies { get; set; }

            [DataContract]
            public class ReleaseControl
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "public_status", Order = 1)]
                public string publicStatus { get; set; }

                [DataMember(Name = "release_datetime", Order = 2)]
                public long releaseDatetime { get; set; }
            }
            [DataMember(Name = "release_controls", Order = 39)]
            public List<ReleaseControl> releaseControls { get; set; }

            [DataContract]
            public class SalesControls
            {
                [DataMember(Name = "package_sales", Order = 0)]
                public bool packageSales { get; set; }

                [DataMember(Name = "download_sales", Order = 1)]
                public bool downloadSales { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "in_app_purchase_countries", Order = 2)]
                public List<string> inAppPurchaseCountries { get; set; }

                [DataMember(Name = "off_device_sales_countries", Order = 3)]
                public List<string> offDeviceSalesCountries { get; set; }

                [DataMember(Name = "on_device_sales_countries", Order = 4)]
                public List<string> onDeviceSalesCountries { get; set; }

                [DataContract]
                public class ExpectedOnlinePrice
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "price", Order = 1)]
                    public long price { get; set; }
                }
                [DataMember(EmitDefaultValue = false, Name = "expected_online_prices", Order = 5)]
                public List<ExpectedOnlinePrice> expectedOnlinePrices { get; set; }

                [DataContract]
                public class PackagePrice
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "display_flag", Order = 1)]
                    public bool displayFlag { get; set; }

                    [DataMember(Name = "price", Order = 2)]
                    public long price { get; set; }
                }
                [DataMember(EmitDefaultValue = false, Name = "package_prices", Order = 6)]
                public List<PackagePrice> packagePrices { get; set; }
            }
            [DataMember(Name = "sales_controls", Order = 40)]
            public SalesControls salesControls { get; set; }

            [DataContract]
            public class BusinessType
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "start_datetime", Order = 0)]
                    public long startDatetime { get; set; }

                    [DataMember(Name = "end_datetime", Order = 1)]
                    public long endDatetime { get; set; }

                    [DataMember(Name = "code", Order = 2)]
                    public string code { get; set; }
                }
                [DataMember(Name = "business_types", Order = 1)]
                public List<Item> businessTypes { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "business_types", Order = 41)]
            public List<BusinessType> businessTypes { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "status", Order = 42)]
            public string status { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "last_update_datetime", Order = 43)]
            public long lastUpdateDatetime { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "scheduled_reflect_datetimes", Order = 44)]
            public List<long> scheduledReflectDatetimes { get; set; }

            // 不足している言語のジャンルを作成
            public void BuildGenre(Languages languages)
            {
                if (genre == null)
                {
                    genre = new Genre();
                    genre.codes = new List<string>();
                }
                genre.names = BuildLanguageItems<Genre.Name>(genre.names, languages);
            }

            // 不足している言語の名称を作成
            public void BuildNames(Languages languages)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
            }

            // 不足している言語の名称を作成、指定方法で名称を変更
            public void UpdateNames(Languages languages, Func<string, string> naming, bool isNameChanged, bool isLaguageChanged)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
                UpdateLanguageItems<Names.FormalName>(names.formalNames, languages, naming, isNameChanged, isLaguageChanged);
            }

            private Aoc FindAoc(string country)
            {
                if (aocs != null)
                {
                    foreach (var aoc in aocs)
                    {
                        if (string.Compare(aoc.country, country) == 0)
                        {
                            return aoc;
                        }
                    }
                }
                return null;
            }

            private bool IsAocIdExist(Aoc aoc, string nsUid)
            {
                if (aoc.ids != null)
                {
                    foreach (var id in aoc.ids)
                    {
                        if (string.Compare(id.id.ToString(), nsUid) == 0)
                        {
                            return true;
                        }
                    }
                }
                return false;
            }

            // 不足している国の Aoc を作成して nsUids を追加
            public void BuildAoc(string country, List<string> nsUids, bool bundleFlag)
            {
                if (aocs == null)
                {
                    aocs = new List<Aoc>();
                }
                var aoc = FindAoc(country);
                if (aoc != null)
                {
                    if (aoc.ids == null)
                    {
                        aoc.ids = new List<Aoc.Id>();
                    }
                    foreach (var nsUid in nsUids)
                    {
                        if (!IsAocIdExist(aoc, nsUid))
                        {
                            var id = new Aoc.Id();
                            id.id = long.Parse(nsUid);
                            id.bundleFlag = bundleFlag;
                            aoc.ids.Add(id);
                        }
                    }
                }
                else
                {
                    aoc = new Aoc();
                    aoc.country = country;
                    aoc.ids = new List<Aoc.Id>();
                    foreach (var nsUid in nsUids)
                    {
                        var id = new Aoc.Id();
                        id.id = long.Parse(nsUid);
                        id.bundleFlag = bundleFlag;
                        aoc.ids.Add(id);
                    }
                    aocs.Add(aoc);
                }
            }

            public void BuildPlayers()
            {
                if (players == null)
                {
                    players = new Players();
                }
                if ((players.normalPlayers == null) ||
                    (players.normalPlayers.min <= 0) ||
                    (players.normalPlayers.max < players.normalPlayers.min))
                {
                    players.normalPlayers = new Players.NormalPlayers();
                    players.normalPlayers.min = 1;
                    players.normalPlayers.max = 8;
                }
                if ((players.localPlayers == null) ||
                    (players.localPlayers.min <= 0) ||
                    (players.localPlayers.max < players.normalPlayers.min))
                {
                    players.localPlayers = new Players.LocalPlayers();
                    players.localPlayers.min = 1;
                    players.localPlayers.max = 8;
                }
                if ((players.internetPlayers == null) ||
                    (players.internetPlayers.min <= 0) ||
                    (players.internetPlayers.max < players.normalPlayers.min))
                {
                    players.internetPlayers = new Players.InternetPlayers();
                    players.internetPlayers.min = 1;
                    players.internetPlayers.max = 8;
                }
            }
        }
    }
}
