﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static partial class Pms
    {
        // Rom ダウンロード可否設定で利用（PATCH による部分更新なので必要なものだけ定義）
        [DataContract]
        public class RomInfo
        {
#if false
            [DataMember(Name = "title_id", Order = 0)]
            public string titleId { get; set; }

            [DataMember(Name = "device_type", Order = 1)]
            public string deviceType { get; set; }

            [DataMember(Name = "type", Order = 2)]
            public string type { get; set; }

            [DataMember(Name = "application_id", Order = 3)]
            public string applicationId { get; set; }

            //! 更新禁止パラメータ
            [DataMember(Name = "aoc_index", Order = 4)]
            public long aocIndex { get; set; }
#endif

            [DataMember(Name = "status", Order = 5)]
            public string status { get; set; }

            [DataMember(Name = "last_update_datetime", Order = 6)]
            public long lastUpdateDatetime { get; set; }

            [DataContract]
            public class Version
            {
                [DataMember(Name = "version", Order = 0)]
                public long version { get; set; }

#if false
                [DataMember(Name = "size", Order = 1)]
                public long size { get; set; }

                [DataMember(Name = "required_system_version", Order = 2)]
                public long requiredSystemVersion { get; set; }

                //! 更新禁止パラメータ
                [DataMember(Name = "required_app_version", Order = 3)]
                public long requiredAppVersion { get; set; }

                [DataMember(Name = "update_notice_flag", Order = 4)]
                public bool updateNoticeFlag { get; set; }
#endif

                [DataMember(Name = "disable_download_flag", Order = 5)]
                public bool disableDownloadFlag { get; set; }

#if false
                [DataMember(Name = "force_update_flag", Order = 6)]
                public bool forceUpdateFlag { get; set; }

                [DataMember(Name = "aoc_tag", Order = 7)]
                public string aocTag { get; set; }

                [DataMember(Name = "distribute_datetime", Order = 8)]
                public long distributeDatetime { get; set; }

                [DataContract]
                public class ControlData
                {
                    [DataMember(Name = "device_lang", Order = 0)]
                    public string deviceLang { get; set; }

                    [DataMember(Name = "title_name", Order = 1)]
                    public string titleName { get; set; }

                    [DataMember(Name = "icon_url", Order = 2)]
                    public string iconUrl { get; set; }

                    [DataMember(Name = "publisher_name", Order = 3)]
                    public string publisherName { get; set; }
                }
                [DataMember(Name = "control_datas", Order = 9)]
                public List<ControlData> controlDatas { get; set; }

                [DataMember(Name = "control_data_disable_download_flag", Order = 10)]
                public bool controlDataDisableDownloadFlag { get; set; }

                [DataMember(Name = "control_data_distribute_datetime", Order = 11)]
                public long controlDataDistributeDatetime { get; set; }
#endif
            }
            [DataMember(Name = "versions", Order = 7)]
            public List<Version> versions { get; set; }
        }
    }
}
