﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommandUtility
{
    public class SingleCommandRunner<CommandClass> where CommandClass : class, new()
    {
        public static void Run(string[] args)
        {
            try
            {
                CommandClass parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs(args, out parsed))
                {
                    throw new Exception("ParseArgs failed");
                }

                ((dynamic)parsed).Run();
            }
            catch (Exception exception)
            {
                PrintException(exception);
                throw;
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.Error.Write("StackTrace: {0}", exception.StackTrace);
        }
    }
}
