﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;

    /// <summary>
    /// ElfSymbolTableEntry のフィールドを操作するためのメソッドを集めたクラス
    /// </summary>
    public static class ElfSymbolTableEntryOperation
    {
        /// <summary>
        /// st_info から ElfSymbolBinding の情報を抽出する
        /// </summary>
        /// <param name="i">st_info</param>
        /// <returns>ElfSymbolBinding</returns>
        public static ElfSymbolBinding GetElfSymbolBinding(byte i)
        {
            return NumericConvert.IntToElfDefine<ElfSymbolBinding>(i >> 4);
        }

        /// <summary>
        /// st_info から ElfSymbolType の情報を抽出する
        /// </summary>
        /// <param name="i">st_info</param>
        /// <returns>ElfSymbolType</returns>
        public static ElfSymbolType GetElfSymbolType(byte i)
        {
            return NumericConvert.IntToElfDefine<ElfSymbolType>(i & 0xf);
        }

        /// <summary>
        /// ElfSymbolBinding と ElfSymbolType から st_infoの情報を作成する
        /// </summary>
        /// <param name="binding">ElfSymbolBinding</param>
        /// <param name="type">ElfSymbolType</param>
        /// <returns>st_info</returns>
        public static byte MakeInfo(ElfSymbolBinding binding, ElfSymbolType type)
        {
            return (byte)(((byte)binding << 4) + ((byte)type & 0xf));
        }
    }
}
