﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;

    /// <summary>
    /// リロケーションの種類
    /// </summary>
    public enum ElfRelocationType
    {
        None = 0,
        ThirtyTwo = 1,
        PC32 = 2,
        GOT32 = 3,
        PLT32 = 4,
        COPY = 5,
        GLOB_DAT = 6,
        JMP_SLOT = 7,
        RELATIVE = 8,
        GOTOFF = 9,
        GOTPC = 10,
    }

    /// <summary>
    /// Elf RelocationEntry のベースクラス
    /// </summary>
    public abstract class ElfRelocationEntry : IElfFile
    {
        public ulong R_Offset { get; set; }
        public ulong R_Info { get; set; }

        /// <summary>
        /// ElfRelocationEntry を読み込みます。
        /// </summary>
        /// <param name="reader">ElfBinaryReader</param>
        public abstract void ReadElfFile(ElfBinaryReader reader);

        /// <summary>
        /// ElfRelocationEntry を書きだします。
        /// </summary>
        /// <param name="reader">ElfBinaryWriter</param>
        public abstract void WriteElfData(ElfBinaryWriter writer);
    }
}
