﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;

    /// <summary>
    /// Elf RelocationAddendEntry のベースクラス
    /// </summary>
    public abstract class ElfRelocationAddendEntry : IElfFile
    {
        public ulong R_Offset { get; set; }
        public ulong R_Info { get; set; }
        public long R_Addend { get; set; }

        /// <summary>
        /// ElfRelocationEntry を読み込みます。
        /// </summary>
        /// <param name="reader">ElfBinaryReader</param>
        public abstract void ReadElfFile(ElfBinaryReader reader);

        /// <summary>
        /// ElfRelocationEntry を書きだします。
        /// </summary>
        /// <param name="reader">ElfBinaryWriter</param>
        public abstract void WriteElfData(ElfBinaryWriter writer);
    }
}
