﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf64
{
    using System;

    /// <summary>
    /// Elf 64-bit ProgramHeader クラス
    /// </summary>
    public class Elf64ProgramHeader : ElfProgramHeader
    {
        public const ushort Elf64HeaderSize = 56;

        /// <summary>
        /// ProgramHeader を読み込みます。
        /// </summary>
        /// <param name="reader">ElfBinaryReader</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            P_Type = reader.ReadUInt32();
            P_Flags = reader.ReadUInt32();
            P_Offset = reader.ReadUInt64();
            P_Vaddr = reader.ReadUInt64();
            P_Paddr = reader.ReadUInt64();
            P_FileSz = reader.ReadUInt64();
            P_MemSz = reader.ReadUInt64();
            P_Align = reader.ReadUInt64();
        }

        /// <summary>
        /// ProgramHeader を書きだします。
        /// </summary>
        /// <param name="reader">ElfBinaryWriter</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            writer.WriteUInt32(P_Type);
            writer.WriteUInt32(P_Flags);
            writer.WriteUInt64(P_Offset);
            writer.WriteUInt64(P_Vaddr);
            writer.WriteUInt64(P_Paddr);
            writer.WriteUInt64(P_FileSz);
            writer.WriteUInt64(P_MemSz);
            writer.WriteUInt64(P_Align);
        }
    }
}
