﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;

    /// <summary>
    /// Elf 32-bit DynamicSection クラス
    /// </summary>
    public class Elf32DynamicSection : ElfDynamicSection
    {
        public const ushort Elf32HeaderSize = 8;

        /// <summary>
        /// ファイルから Dynamic Section を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            D_Tag = checked((int)reader.ReadUInt32());
            D_Un = reader.ReadUInt32();
        }

        /// <summary>
        /// ファイルに Dynamic Section を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            checked
            {
                writer.WriteUInt32((uint)D_Tag);
                writer.WriteUInt32((uint)D_Un);
            }
        }
    }
}
