﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <msclr/marshal.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_IStorage.h>

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;

    private class StorageArchiveReaderImplBase
    {
    public:
        StorageArchiveReaderImplBase()
            : m_pStorage(nullptr)
        {
        }

        explicit StorageArchiveReaderImplBase(fs::IStorage* pStorage)
            : m_pStorage(pStorage)
        {
        }

        virtual array<byte>^ Read(Int64 offset, Int32 size)
        {
            if (size >= 0x7FFFFFFF)
            {
                throw gcnew InvalidOperationException("Input size is too large.");
            }

            if (size < 0)
            {
                throw gcnew InvalidOperationException("Input size must be positive.");
            }

            size_t size32Bit = (size_t)size;

            array<Byte>^ bytes = gcnew array<Byte>(size32Bit);

            if (size == 0)
            {
                return bytes;
            }

            Result result;
            {
                pin_ptr<unsigned char> ptr = &bytes[0];
                std::memset(ptr, 0, size32Bit);
                result = m_pStorage->Read(offset, ptr, size32Bit);
                ptr = nullptr;
            }
            if (result.IsFailure())
            {
                throw gcnew ArgumentException(String::Format("Failed to Read 0x{0:X8}.", result.GetInnerValueForDebug()));
            }

            return bytes;
        }

        virtual int64_t GetSize()
        {
            int64_t storageSize = 0;
            auto result = m_pStorage->GetSize(&storageSize);
            if (result.IsFailure())
            {
                throw gcnew ArgumentException(String::Format("Failed to GetSize 0x{0:X8}.", result.GetInnerValueForDebug()));
            }
            return storageSize;
        }

    protected:
        fs::IStorage* m_pStorage;
    };

}}}
