﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/fs/fs_IStorage.h>
#include "IStorageArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;

using namespace nn;

    class StorageArchiveReaderImpl;
    public ref class StorageArchiveReader : public IStorageArchiveReader
    {
    public:
        StorageArchiveReader(Stream^ stream);
        ~StorageArchiveReader();
        !StorageArchiveReader();

        virtual array<byte>^ Read(Int64 offset, Int32 size);
        virtual int64_t GetSize();

    internal:
        StorageArchiveReader(std::shared_ptr<fs::IStorage> storage);
        StorageArchiveReader(fs::IStorage* pStorage, std::shared_ptr<fs::IStorage> storageHolder);

    private:
        StorageArchiveReaderImpl* m_Impl;
    };

}}}
