﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssystem/utilTool/fs_SparseStorageBuilder.h>
#include "NintendoContentArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;

class SparseStorageStreamImpl;

public ref class SparseStorageStream
{
public:
    literal Int32 BlockSizeMin = (Int32)nn::fssystem::utilTool::SparseStorageBuilder::BlockSizeMin;

public:
    SparseStorageStream(Int32 blockSize, Int32 eraseSize);
    ~SparseStorageStream();
    !SparseStorageStream();

    NintendoContentArchiveFsHeaderInfo^ Build(NintendoContentArchiveReader^ targetReader, NintendoContentArchiveReader^ patchReader, Int32 fsIndex, Int64 physicalOffset);
    void WriteTable(array<Byte>^ tableBuffer);
    array<Byte>^ ReadData(Int64 offset, Int32 size);
    void OutputBuildLog(Stream^ tableStream);
    Int64 GetDataSize();
    Int32 GetTableSize();

private:
    SparseStorageStreamImpl* m_pImpl;
};

class SparseStorageArchiveStreamImpl;

public ref class SparseStorageArchiveStream
{
public:
    property String^ Type;

    SparseStorageArchiveStream(String^ type, NintendoContentArchiveReader^ reader);
    SparseStorageArchiveStream(String^ type, array<Byte>^ buffer);
    ~SparseStorageArchiveStream();
    !SparseStorageArchiveStream();

    void Attach(NintendoContentArchiveReader^ reader);
    array<Byte>^ ReadData(Int64 offset, Int32 size);
    Int64 GetDataSize();

private:
    SparseStorageArchiveStreamImpl* m_pImpl;
};

}}}
