﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <string>
#include <msclr/marshal.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/fs/fs_IStorage.h>
#include <nn/fssystem/fs_PartitionFileSystem.h>

#include "../Util/DeclareAlive.h"
#include "PartitionFileSystemArchiveReader.h"
#include "NintendoContentArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;
using namespace nn::fssystem;

    public ref class NintendoSubmissionPackageReader : public PartitionFileSystemArchiveReader
    {
    public:
        NintendoSubmissionPackageReader(Stream^ stream) : PartitionFileSystemArchiveReader(stream)
        {
        }

        NintendoSubmissionPackageReader(String^ path) : PartitionFileSystemArchiveReader(m_Stream = gcnew FileStream(path, FileMode::Open, FileAccess::Read))
        {
        }

        !NintendoSubmissionPackageReader()
        {
            if (m_Stream != nullptr)
            {
                delete m_Stream;
            }
        }

        ~NintendoSubmissionPackageReader()
        {
            this->!NintendoSubmissionPackageReader();
        }

        virtual NintendoContentArchiveReader^ OpenNintendoContentArchiveReader(String^ fileName, IKeyGenerator^ keyGenerator)
        {
            std::shared_ptr<fs::IStorage> storage;
            this->OpenFileStorage(&storage, fileName);
            return Util::ReturnAndDeclareAlive(this, gcnew NintendoContentArchiveReader(std::move(storage), keyGenerator));
        }

        UInt32 GetAesCtrGeneration(IKeyGenerator^ keyGenerator)
        {
            if( !m_AesCtrGeneration.HasValue )
            {
                UInt32 generationMax = 0;

                // nsp 内で最大の世代番号を取得
                for each(auto tuple in ListFileInfo())
                {
                    if( Path::GetExtension(tuple->Item1) == ".nca" )
                    {
                        auto reader = OpenNintendoContentArchiveReader(tuple->Item1, keyGenerator);
                        auto generation = reader->GetAesCtrGeneration();

                        if( generationMax < generation )
                        {
                            generationMax = generation;
                        }
                    }
                }

                m_AesCtrGeneration = generationMax;
            }
            return m_AesCtrGeneration.Value;
        }

    private:
        Nullable<UInt32> m_AesCtrGeneration;
        Stream^ m_Stream;
    };

}}}
